package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchCreateDcdnWafRules invokes the dcdn.BatchCreateDcdnWafRules API synchronously
func (client *Client) BatchCreateDcdnWafRules(request *BatchCreateDcdnWafRulesRequest) (response *BatchCreateDcdnWafRulesResponse, err error) {
	response = CreateBatchCreateDcdnWafRulesResponse()
	err = client.DoAction(request, response)
	return
}

// BatchCreateDcdnWafRulesWithChan invokes the dcdn.BatchCreateDcdnWafRules API asynchronously
func (client *Client) BatchCreateDcdnWafRulesWithChan(request *BatchCreateDcdnWafRulesRequest) (<-chan *BatchCreateDcdnWafRulesResponse, <-chan error) {
	responseChan := make(chan *BatchCreateDcdnWafRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchCreateDcdnWafRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchCreateDcdnWafRulesWithCallback invokes the dcdn.BatchCreateDcdnWafRules API asynchronously
func (client *Client) BatchCreateDcdnWafRulesWithCallback(request *BatchCreateDcdnWafRulesRequest, callback func(response *BatchCreateDcdnWafRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchCreateDcdnWafRulesResponse
		var err error
		defer close(result)
		response, err = client.BatchCreateDcdnWafRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchCreateDcdnWafRulesRequest is the request struct for api BatchCreateDcdnWafRules
type BatchCreateDcdnWafRulesRequest struct {
	*requests.RpcRequest
	PolicyId    requests.Integer `position:"Body" name:"PolicyId"`
	RuleConfigs string           `position:"Body" name:"RuleConfigs"`
}

// BatchCreateDcdnWafRulesResponse is the response struct for api BatchCreateDcdnWafRules
type BatchCreateDcdnWafRulesResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	RuleIds   RuleIds `json:"RuleIds" xml:"RuleIds"`
}

// CreateBatchCreateDcdnWafRulesRequest creates a request to invoke BatchCreateDcdnWafRules API
func CreateBatchCreateDcdnWafRulesRequest() (request *BatchCreateDcdnWafRulesRequest) {
	request = &BatchCreateDcdnWafRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "BatchCreateDcdnWafRules", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchCreateDcdnWafRulesResponse creates a response to parse from BatchCreateDcdnWafRules response
func CreateBatchCreateDcdnWafRulesResponse() (response *BatchCreateDcdnWafRulesResponse) {
	response = &BatchCreateDcdnWafRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
