package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigLayer4RuleBakMode invokes the ddoscoo.ConfigLayer4RuleBakMode API synchronously
func (client *Client) ConfigLayer4RuleBakMode(request *ConfigLayer4RuleBakModeRequest) (response *ConfigLayer4RuleBakModeResponse, err error) {
	response = CreateConfigLayer4RuleBakModeResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigLayer4RuleBakModeWithChan invokes the ddoscoo.ConfigLayer4RuleBakMode API asynchronously
func (client *Client) ConfigLayer4RuleBakModeWithChan(request *ConfigLayer4RuleBakModeRequest) (<-chan *ConfigLayer4RuleBakModeResponse, <-chan error) {
	responseChan := make(chan *ConfigLayer4RuleBakModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigLayer4RuleBakMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigLayer4RuleBakModeWithCallback invokes the ddoscoo.ConfigLayer4RuleBakMode API asynchronously
func (client *Client) ConfigLayer4RuleBakModeWithCallback(request *ConfigLayer4RuleBakModeRequest, callback func(response *ConfigLayer4RuleBakModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigLayer4RuleBakModeResponse
		var err error
		defer close(result)
		response, err = client.ConfigLayer4RuleBakMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigLayer4RuleBakModeRequest is the request struct for api ConfigLayer4RuleBakMode
type ConfigLayer4RuleBakModeRequest struct {
	*requests.RpcRequest
	BakMode   string `position:"Query" name:"BakMode"`
	SourceIp  string `position:"Query" name:"SourceIp"`
	Listeners string `position:"Query" name:"Listeners"`
}

// ConfigLayer4RuleBakModeResponse is the response struct for api ConfigLayer4RuleBakMode
type ConfigLayer4RuleBakModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigLayer4RuleBakModeRequest creates a request to invoke ConfigLayer4RuleBakMode API
func CreateConfigLayer4RuleBakModeRequest() (request *ConfigLayer4RuleBakModeRequest) {
	request = &ConfigLayer4RuleBakModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ConfigLayer4RuleBakMode", "", "")
	request.Method = requests.POST
	return
}

// CreateConfigLayer4RuleBakModeResponse creates a response to parse from ConfigLayer4RuleBakMode response
func CreateConfigLayer4RuleBakModeResponse() (response *ConfigLayer4RuleBakModeResponse) {
	response = &ConfigLayer4RuleBakModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
