package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDDosEventIsp invokes the ddoscoo.DescribeDDosEventIsp API synchronously
func (client *Client) DescribeDDosEventIsp(request *DescribeDDosEventIspRequest) (response *DescribeDDosEventIspResponse, err error) {
	response = CreateDescribeDDosEventIspResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDDosEventIspWithChan invokes the ddoscoo.DescribeDDosEventIsp API asynchronously
func (client *Client) DescribeDDosEventIspWithChan(request *DescribeDDosEventIspRequest) (<-chan *DescribeDDosEventIspResponse, <-chan error) {
	responseChan := make(chan *DescribeDDosEventIspResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDDosEventIsp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDDosEventIspWithCallback invokes the ddoscoo.DescribeDDosEventIsp API asynchronously
func (client *Client) DescribeDDosEventIspWithCallback(request *DescribeDDosEventIspRequest, callback func(response *DescribeDDosEventIspResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDDosEventIspResponse
		var err error
		defer close(result)
		response, err = client.DescribeDDosEventIsp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDDosEventIspRequest is the request struct for api DescribeDDosEventIsp
type DescribeDDosEventIspRequest struct {
	*requests.RpcRequest
	Ip        string           `position:"Query" name:"Ip"`
	StartTime requests.Integer `position:"Query" name:"StartTime"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
	EventType string           `position:"Query" name:"EventType"`
}

// DescribeDDosEventIspResponse is the response struct for api DescribeDDosEventIsp
type DescribeDDosEventIspResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Isps      []EventIsp `json:"Isps" xml:"Isps"`
}

// CreateDescribeDDosEventIspRequest creates a request to invoke DescribeDDosEventIsp API
func CreateDescribeDDosEventIspRequest() (request *DescribeDDosEventIspRequest) {
	request = &DescribeDDosEventIspRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeDDosEventIsp", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDDosEventIspResponse creates a response to parse from DescribeDDosEventIsp response
func CreateDescribeDDosEventIspResponse() (response *DescribeDDosEventIspResponse) {
	response = &DescribeDDosEventIspResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
