package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSchedulerRules invokes the ddoscoo.DescribeSchedulerRules API synchronously
func (client *Client) DescribeSchedulerRules(request *DescribeSchedulerRulesRequest) (response *DescribeSchedulerRulesResponse, err error) {
	response = CreateDescribeSchedulerRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSchedulerRulesWithChan invokes the ddoscoo.DescribeSchedulerRules API asynchronously
func (client *Client) DescribeSchedulerRulesWithChan(request *DescribeSchedulerRulesRequest) (<-chan *DescribeSchedulerRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeSchedulerRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSchedulerRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSchedulerRulesWithCallback invokes the ddoscoo.DescribeSchedulerRules API asynchronously
func (client *Client) DescribeSchedulerRulesWithCallback(request *DescribeSchedulerRulesRequest, callback func(response *DescribeSchedulerRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSchedulerRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeSchedulerRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSchedulerRulesRequest is the request struct for api DescribeSchedulerRules
type DescribeSchedulerRulesRequest struct {
	*requests.RpcRequest
	IsOffset        requests.Boolean `position:"Query" name:"IsOffset"`
	RuleName        string           `position:"Query" name:"RuleName"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	Offset          requests.Integer `position:"Query" name:"Offset"`
}

// DescribeSchedulerRulesResponse is the response struct for api DescribeSchedulerRules
type DescribeSchedulerRulesResponse struct {
	*responses.BaseResponse
	TotalCount     string          `json:"TotalCount" xml:"TotalCount"`
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	SchedulerRules []SchedulerRule `json:"SchedulerRules" xml:"SchedulerRules"`
}

// CreateDescribeSchedulerRulesRequest creates a request to invoke DescribeSchedulerRules API
func CreateDescribeSchedulerRulesRequest() (request *DescribeSchedulerRulesRequest) {
	request = &DescribeSchedulerRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeSchedulerRules", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSchedulerRulesResponse creates a response to parse from DescribeSchedulerRules response
func CreateDescribeSchedulerRulesResponse() (response *DescribeSchedulerRulesResponse) {
	response = &DescribeSchedulerRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
