package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebAccessLogDispatchStatus invokes the ddoscoo.DescribeWebAccessLogDispatchStatus API synchronously
func (client *Client) DescribeWebAccessLogDispatchStatus(request *DescribeWebAccessLogDispatchStatusRequest) (response *DescribeWebAccessLogDispatchStatusResponse, err error) {
	response = CreateDescribeWebAccessLogDispatchStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebAccessLogDispatchStatusWithChan invokes the ddoscoo.DescribeWebAccessLogDispatchStatus API asynchronously
func (client *Client) DescribeWebAccessLogDispatchStatusWithChan(request *DescribeWebAccessLogDispatchStatusRequest) (<-chan *DescribeWebAccessLogDispatchStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeWebAccessLogDispatchStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebAccessLogDispatchStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebAccessLogDispatchStatusWithCallback invokes the ddoscoo.DescribeWebAccessLogDispatchStatus API asynchronously
func (client *Client) DescribeWebAccessLogDispatchStatusWithCallback(request *DescribeWebAccessLogDispatchStatusRequest, callback func(response *DescribeWebAccessLogDispatchStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebAccessLogDispatchStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebAccessLogDispatchStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebAccessLogDispatchStatusRequest is the request struct for api DescribeWebAccessLogDispatchStatus
type DescribeWebAccessLogDispatchStatusRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	Lang            string           `position:"Query" name:"Lang"`
}

// DescribeWebAccessLogDispatchStatusResponse is the response struct for api DescribeWebAccessLogDispatchStatus
type DescribeWebAccessLogDispatchStatusResponse struct {
	*responses.BaseResponse
	TotalCount      int                   `json:"TotalCount" xml:"TotalCount"`
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	SlsConfigStatus []SlsConfigStatusItem `json:"SlsConfigStatus" xml:"SlsConfigStatus"`
}

// CreateDescribeWebAccessLogDispatchStatusRequest creates a request to invoke DescribeWebAccessLogDispatchStatus API
func CreateDescribeWebAccessLogDispatchStatusRequest() (request *DescribeWebAccessLogDispatchStatusRequest) {
	request = &DescribeWebAccessLogDispatchStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeWebAccessLogDispatchStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeWebAccessLogDispatchStatusResponse creates a response to parse from DescribeWebAccessLogDispatchStatus response
func CreateDescribeWebAccessLogDispatchStatusResponse() (response *DescribeWebAccessLogDispatchStatusResponse) {
	response = &DescribeWebAccessLogDispatchStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
