package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWebCacheSwitch invokes the ddoscoo.ModifyWebCacheSwitch API synchronously
func (client *Client) ModifyWebCacheSwitch(request *ModifyWebCacheSwitchRequest) (response *ModifyWebCacheSwitchResponse, err error) {
	response = CreateModifyWebCacheSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWebCacheSwitchWithChan invokes the ddoscoo.ModifyWebCacheSwitch API asynchronously
func (client *Client) ModifyWebCacheSwitchWithChan(request *ModifyWebCacheSwitchRequest) (<-chan *ModifyWebCacheSwitchResponse, <-chan error) {
	responseChan := make(chan *ModifyWebCacheSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWebCacheSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWebCacheSwitchWithCallback invokes the ddoscoo.ModifyWebCacheSwitch API asynchronously
func (client *Client) ModifyWebCacheSwitchWithCallback(request *ModifyWebCacheSwitchRequest, callback func(response *ModifyWebCacheSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWebCacheSwitchResponse
		var err error
		defer close(result)
		response, err = client.ModifyWebCacheSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWebCacheSwitchRequest is the request struct for api ModifyWebCacheSwitch
type ModifyWebCacheSwitchRequest struct {
	*requests.RpcRequest
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Enable          requests.Integer `position:"Query" name:"Enable"`
	Domain          string           `position:"Query" name:"Domain"`
}

// ModifyWebCacheSwitchResponse is the response struct for api ModifyWebCacheSwitch
type ModifyWebCacheSwitchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyWebCacheSwitchRequest creates a request to invoke ModifyWebCacheSwitch API
func CreateModifyWebCacheSwitchRequest() (request *ModifyWebCacheSwitchRequest) {
	request = &ModifyWebCacheSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyWebCacheSwitch", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyWebCacheSwitchResponse creates a response to parse from ModifyWebCacheSwitch response
func CreateModifyWebCacheSwitchResponse() (response *ModifyWebCacheSwitchResponse) {
	response = &ModifyWebCacheSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
