package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTaskFlowInstance invokes the dms_enterprise.ListTaskFlowInstance API synchronously
func (client *Client) ListTaskFlowInstance(request *ListTaskFlowInstanceRequest) (response *ListTaskFlowInstanceResponse, err error) {
	response = CreateListTaskFlowInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ListTaskFlowInstanceWithChan invokes the dms_enterprise.ListTaskFlowInstance API asynchronously
func (client *Client) ListTaskFlowInstanceWithChan(request *ListTaskFlowInstanceRequest) (<-chan *ListTaskFlowInstanceResponse, <-chan error) {
	responseChan := make(chan *ListTaskFlowInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTaskFlowInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTaskFlowInstanceWithCallback invokes the dms_enterprise.ListTaskFlowInstance API asynchronously
func (client *Client) ListTaskFlowInstanceWithCallback(request *ListTaskFlowInstanceRequest, callback func(response *ListTaskFlowInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTaskFlowInstanceResponse
		var err error
		defer close(result)
		response, err = client.ListTaskFlowInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTaskFlowInstanceRequest is the request struct for api ListTaskFlowInstance
type ListTaskFlowInstanceRequest struct {
	*requests.RpcRequest
	TriggerType    requests.Integer `position:"Query" name:"TriggerType"`
	DagId          requests.Integer `position:"Query" name:"DagId"`
	Tid            requests.Integer `position:"Query" name:"Tid"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	PageIndex      requests.Integer `position:"Query" name:"PageIndex"`
	StartTimeBegin string           `position:"Query" name:"StartTimeBegin"`
	StartTimeEnd   string           `position:"Query" name:"StartTimeEnd"`
}

// ListTaskFlowInstanceResponse is the response struct for api ListTaskFlowInstance
type ListTaskFlowInstanceResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	ErrorCode       string          `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage    string          `json:"ErrorMessage" xml:"ErrorMessage"`
	Success         bool            `json:"Success" xml:"Success"`
	TotalCount      int             `json:"TotalCount" xml:"TotalCount"`
	DAGInstanceList DAGInstanceList `json:"DAGInstanceList" xml:"DAGInstanceList"`
}

// CreateListTaskFlowInstanceRequest creates a request to invoke ListTaskFlowInstance API
func CreateListTaskFlowInstanceRequest() (request *ListTaskFlowInstanceRequest) {
	request = &ListTaskFlowInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListTaskFlowInstance", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTaskFlowInstanceResponse creates a response to parse from ListTaskFlowInstance response
func CreateListTaskFlowInstanceResponse() (response *ListTaskFlowInstanceResponse) {
	response = &ListTaskFlowInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
