package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTaskFlowsByPage invokes the dms_enterprise.ListTaskFlowsByPage API synchronously
func (client *Client) ListTaskFlowsByPage(request *ListTaskFlowsByPageRequest) (response *ListTaskFlowsByPageResponse, err error) {
	response = CreateListTaskFlowsByPageResponse()
	err = client.DoAction(request, response)
	return
}

// ListTaskFlowsByPageWithChan invokes the dms_enterprise.ListTaskFlowsByPage API asynchronously
func (client *Client) ListTaskFlowsByPageWithChan(request *ListTaskFlowsByPageRequest) (<-chan *ListTaskFlowsByPageResponse, <-chan error) {
	responseChan := make(chan *ListTaskFlowsByPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTaskFlowsByPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTaskFlowsByPageWithCallback invokes the dms_enterprise.ListTaskFlowsByPage API asynchronously
func (client *Client) ListTaskFlowsByPageWithCallback(request *ListTaskFlowsByPageRequest, callback func(response *ListTaskFlowsByPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTaskFlowsByPageResponse
		var err error
		defer close(result)
		response, err = client.ListTaskFlowsByPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTaskFlowsByPageRequest is the request struct for api ListTaskFlowsByPage
type ListTaskFlowsByPageRequest struct {
	*requests.RpcRequest
	SearchKey           string           `position:"Query" name:"SearchKey"`
	Tid                 requests.Integer `position:"Query" name:"Tid"`
	PageSize            requests.Integer `position:"Query" name:"PageSize"`
	PageIndex           requests.Integer `position:"Query" name:"PageIndex"`
	NeedLastDagInstance requests.Boolean `position:"Query" name:"NeedLastDagInstance"`
}

// ListTaskFlowsByPageResponse is the response struct for api ListTaskFlowsByPage
type ListTaskFlowsByPageResponse struct {
	*responses.BaseResponse
	RequestId    string                            `json:"RequestId" xml:"RequestId"`
	ErrorCode    string                            `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                            `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool                              `json:"Success" xml:"Success"`
	TotalCount   int                               `json:"TotalCount" xml:"TotalCount"`
	TaskFlowList TaskFlowListInListTaskFlowsByPage `json:"TaskFlowList" xml:"TaskFlowList"`
}

// CreateListTaskFlowsByPageRequest creates a request to invoke ListTaskFlowsByPage API
func CreateListTaskFlowsByPageRequest() (request *ListTaskFlowsByPageRequest) {
	request = &ListTaskFlowsByPageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListTaskFlowsByPage", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTaskFlowsByPageResponse creates a response to parse from ListTaskFlowsByPage response
func CreateListTaskFlowsByPageResponse() (response *ListTaskFlowsByPageResponse) {
	response = &ListTaskFlowsByPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
