package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PollTaskResult invokes the domain.PollTaskResult API synchronously
func (client *Client) PollTaskResult(request *PollTaskResultRequest) (response *PollTaskResultResponse, err error) {
	response = CreatePollTaskResultResponse()
	err = client.DoAction(request, response)
	return
}

// PollTaskResultWithChan invokes the domain.PollTaskResult API asynchronously
func (client *Client) PollTaskResultWithChan(request *PollTaskResultRequest) (<-chan *PollTaskResultResponse, <-chan error) {
	responseChan := make(chan *PollTaskResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PollTaskResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PollTaskResultWithCallback invokes the domain.PollTaskResult API asynchronously
func (client *Client) PollTaskResultWithCallback(request *PollTaskResultRequest, callback func(response *PollTaskResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PollTaskResultResponse
		var err error
		defer close(result)
		response, err = client.PollTaskResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PollTaskResultRequest is the request struct for api PollTaskResult
type PollTaskResultRequest struct {
	*requests.RpcRequest
	DomainName       string           `position:"Query" name:"DomainName"`
	PageNum          requests.Integer `position:"Query" name:"PageNum"`
	TaskResultStatus requests.Integer `position:"Query" name:"TaskResultStatus"`
	InstanceId       string           `position:"Query" name:"InstanceId"`
	UserClientIp     string           `position:"Query" name:"UserClientIp"`
	TaskNo           string           `position:"Query" name:"TaskNo"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	Lang             string           `position:"Query" name:"Lang"`
}

// PollTaskResultResponse is the response struct for api PollTaskResult
type PollTaskResultResponse struct {
	*responses.BaseResponse
	PrePage        bool                 `json:"PrePage" xml:"PrePage"`
	CurrentPageNum int                  `json:"CurrentPageNum" xml:"CurrentPageNum"`
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	PageSize       int                  `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int                  `json:"TotalPageNum" xml:"TotalPageNum"`
	TotalItemNum   int                  `json:"TotalItemNum" xml:"TotalItemNum"`
	NextPage       bool                 `json:"NextPage" xml:"NextPage"`
	Data           DataInPollTaskResult `json:"Data" xml:"Data"`
}

// CreatePollTaskResultRequest creates a request to invoke PollTaskResult API
func CreatePollTaskResultRequest() (request *PollTaskResultRequest) {
	request = &PollTaskResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "PollTaskResult", "", "")
	request.Method = requests.POST
	return
}

// CreatePollTaskResultResponse creates a response to parse from PollTaskResult response
func CreatePollTaskResultResponse() (response *PollTaskResultResponse) {
	response = &PollTaskResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
