package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEnsAssociation invokes the domain.QueryEnsAssociation API synchronously
func (client *Client) QueryEnsAssociation(request *QueryEnsAssociationRequest) (response *QueryEnsAssociationResponse, err error) {
	response = CreateQueryEnsAssociationResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEnsAssociationWithChan invokes the domain.QueryEnsAssociation API asynchronously
func (client *Client) QueryEnsAssociationWithChan(request *QueryEnsAssociationRequest) (<-chan *QueryEnsAssociationResponse, <-chan error) {
	responseChan := make(chan *QueryEnsAssociationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEnsAssociation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEnsAssociationWithCallback invokes the domain.QueryEnsAssociation API asynchronously
func (client *Client) QueryEnsAssociationWithCallback(request *QueryEnsAssociationRequest, callback func(response *QueryEnsAssociationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEnsAssociationResponse
		var err error
		defer close(result)
		response, err = client.QueryEnsAssociation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEnsAssociationRequest is the request struct for api QueryEnsAssociation
type QueryEnsAssociationRequest struct {
	*requests.RpcRequest
	DomainName   string `position:"Query" name:"DomainName"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// QueryEnsAssociationResponse is the response struct for api QueryEnsAssociation
type QueryEnsAssociationResponse struct {
	*responses.BaseResponse
	Address   string `json:"Address" xml:"Address"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateQueryEnsAssociationRequest creates a request to invoke QueryEnsAssociation API
func CreateQueryEnsAssociationRequest() (request *QueryEnsAssociationRequest) {
	request = &QueryEnsAssociationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "QueryEnsAssociation", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryEnsAssociationResponse creates a response to parse from QueryEnsAssociation response
func CreateQueryEnsAssociationResponse() (response *QueryEnsAssociationResponse) {
	response = &QueryEnsAssociationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
