package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReserveIntlDomain invokes the domain.ReserveIntlDomain API synchronously
func (client *Client) ReserveIntlDomain(request *ReserveIntlDomainRequest) (response *ReserveIntlDomainResponse, err error) {
	response = CreateReserveIntlDomainResponse()
	err = client.DoAction(request, response)
	return
}

// ReserveIntlDomainWithChan invokes the domain.ReserveIntlDomain API asynchronously
func (client *Client) ReserveIntlDomainWithChan(request *ReserveIntlDomainRequest) (<-chan *ReserveIntlDomainResponse, <-chan error) {
	responseChan := make(chan *ReserveIntlDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReserveIntlDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReserveIntlDomainWithCallback invokes the domain.ReserveIntlDomain API asynchronously
func (client *Client) ReserveIntlDomainWithCallback(request *ReserveIntlDomainRequest, callback func(response *ReserveIntlDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReserveIntlDomainResponse
		var err error
		defer close(result)
		response, err = client.ReserveIntlDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReserveIntlDomainRequest is the request struct for api ReserveIntlDomain
type ReserveIntlDomainRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Body" name:"DomainName"`
}

// ReserveIntlDomainResponse is the response struct for api ReserveIntlDomain
type ReserveIntlDomainResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string   `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string   `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrorMsg       string   `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode      string   `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool     `json:"Success" xml:"Success"`
	AllowRetry     bool     `json:"AllowRetry" xml:"AllowRetry"`
	AppName        string   `json:"AppName" xml:"AppName"`
	AuctionId      string   `json:"AuctionId" xml:"AuctionId"`
	ErrorArgs      []string `json:"ErrorArgs" xml:"ErrorArgs"`
}

// CreateReserveIntlDomainRequest creates a request to invoke ReserveIntlDomain API
func CreateReserveIntlDomainRequest() (request *ReserveIntlDomainRequest) {
	request = &ReserveIntlDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-02-08", "ReserveIntlDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateReserveIntlDomainResponse creates a response to parse from ReserveIntlDomain response
func CreateReserveIntlDomainResponse() (response *ReserveIntlDomainResponse) {
	response = &ReserveIntlDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
