package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigureMigrationJobAlert invokes the dts.ConfigureMigrationJobAlert API synchronously
func (client *Client) ConfigureMigrationJobAlert(request *ConfigureMigrationJobAlertRequest) (response *ConfigureMigrationJobAlertResponse, err error) {
	response = CreateConfigureMigrationJobAlertResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigureMigrationJobAlertWithChan invokes the dts.ConfigureMigrationJobAlert API asynchronously
func (client *Client) ConfigureMigrationJobAlertWithChan(request *ConfigureMigrationJobAlertRequest) (<-chan *ConfigureMigrationJobAlertResponse, <-chan error) {
	responseChan := make(chan *ConfigureMigrationJobAlertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigureMigrationJobAlert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigureMigrationJobAlertWithCallback invokes the dts.ConfigureMigrationJobAlert API asynchronously
func (client *Client) ConfigureMigrationJobAlertWithCallback(request *ConfigureMigrationJobAlertRequest, callback func(response *ConfigureMigrationJobAlertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigureMigrationJobAlertResponse
		var err error
		defer close(result)
		response, err = client.ConfigureMigrationJobAlert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigureMigrationJobAlertRequest is the request struct for api ConfigureMigrationJobAlert
type ConfigureMigrationJobAlertRequest struct {
	*requests.RpcRequest
	MigrationJobId   string `position:"Query" name:"MigrationJobId"`
	AccountId        string `position:"Query" name:"AccountId"`
	DelayAlertPhone  string `position:"Query" name:"DelayAlertPhone"`
	DelayOverSeconds string `position:"Query" name:"DelayOverSeconds"`
	DelayAlertStatus string `position:"Query" name:"DelayAlertStatus"`
	OwnerId          string `position:"Query" name:"OwnerId"`
	ErrorAlertPhone  string `position:"Query" name:"ErrorAlertPhone"`
	ErrorAlertStatus string `position:"Query" name:"ErrorAlertStatus"`
}

// ConfigureMigrationJobAlertResponse is the response struct for api ConfigureMigrationJobAlert
type ConfigureMigrationJobAlertResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	Success    string `json:"Success" xml:"Success"`
	ErrMessage string `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateConfigureMigrationJobAlertRequest creates a request to invoke ConfigureMigrationJobAlert API
func CreateConfigureMigrationJobAlertRequest() (request *ConfigureMigrationJobAlertRequest) {
	request = &ConfigureMigrationJobAlertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "ConfigureMigrationJobAlert", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateConfigureMigrationJobAlertResponse creates a response to parse from ConfigureMigrationJobAlert response
func CreateConfigureMigrationJobAlertResponse() (response *ConfigureMigrationJobAlertResponse) {
	response = &ConfigureMigrationJobAlertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
