package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterOperateLogs invokes the dts.DescribeClusterOperateLogs API synchronously
func (client *Client) DescribeClusterOperateLogs(request *DescribeClusterOperateLogsRequest) (response *DescribeClusterOperateLogsResponse, err error) {
	response = CreateDescribeClusterOperateLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterOperateLogsWithChan invokes the dts.DescribeClusterOperateLogs API asynchronously
func (client *Client) DescribeClusterOperateLogsWithChan(request *DescribeClusterOperateLogsRequest) (<-chan *DescribeClusterOperateLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterOperateLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterOperateLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterOperateLogsWithCallback invokes the dts.DescribeClusterOperateLogs API asynchronously
func (client *Client) DescribeClusterOperateLogsWithCallback(request *DescribeClusterOperateLogsRequest, callback func(response *DescribeClusterOperateLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterOperateLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterOperateLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterOperateLogsRequest is the request struct for api DescribeClusterOperateLogs
type DescribeClusterOperateLogsRequest struct {
	*requests.RpcRequest
	ClientToken        string           `position:"Body" name:"ClientToken"`
	DedicatedClusterId string           `position:"Body" name:"DedicatedClusterId"`
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	PageNumber         requests.Integer `position:"Body" name:"PageNumber"`
	AccountId          string           `position:"Body" name:"AccountId"`
	PageSize           requests.Integer `position:"Body" name:"PageSize"`
	DtsJobId           string           `position:"Body" name:"DtsJobId"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	OwnerID            string           `position:"Body" name:"OwnerID"`
}

// DescribeClusterOperateLogsResponse is the response struct for api DescribeClusterOperateLogs
type DescribeClusterOperateLogsResponse struct {
	*responses.BaseResponse
	PageNumber       int         `json:"PageNumber" xml:"PageNumber"`
	PageRecordCount  int         `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount int64       `json:"TotalRecordCount" xml:"TotalRecordCount"`
	Success          bool        `json:"Success" xml:"Success"`
	Code             string      `json:"Code" xml:"Code"`
	ErrCode          string      `json:"ErrCode" xml:"ErrCode"`
	ErrMessage       string      `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage   string      `json:"DynamicMessage" xml:"DynamicMessage"`
	HttpStatusCode   int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId        string      `json:"RequestId" xml:"RequestId"`
	DataPoints       []DataPoint `json:"DataPoints" xml:"DataPoints"`
}

// CreateDescribeClusterOperateLogsRequest creates a request to invoke DescribeClusterOperateLogs API
func CreateDescribeClusterOperateLogsRequest() (request *DescribeClusterOperateLogsRequest) {
	request = &DescribeClusterOperateLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeClusterOperateLogs", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClusterOperateLogsResponse creates a response to parse from DescribeClusterOperateLogs response
func CreateDescribeClusterOperateLogsResponse() (response *DescribeClusterOperateLogsResponse) {
	response = &DescribeClusterOperateLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
