package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataCheckTableDiffDetails invokes the dts.DescribeDataCheckTableDiffDetails API synchronously
func (client *Client) DescribeDataCheckTableDiffDetails(request *DescribeDataCheckTableDiffDetailsRequest) (response *DescribeDataCheckTableDiffDetailsResponse, err error) {
	response = CreateDescribeDataCheckTableDiffDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataCheckTableDiffDetailsWithChan invokes the dts.DescribeDataCheckTableDiffDetails API asynchronously
func (client *Client) DescribeDataCheckTableDiffDetailsWithChan(request *DescribeDataCheckTableDiffDetailsRequest) (<-chan *DescribeDataCheckTableDiffDetailsResponse, <-chan error) {
	responseChan := make(chan *DescribeDataCheckTableDiffDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataCheckTableDiffDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataCheckTableDiffDetailsWithCallback invokes the dts.DescribeDataCheckTableDiffDetails API asynchronously
func (client *Client) DescribeDataCheckTableDiffDetailsWithCallback(request *DescribeDataCheckTableDiffDetailsRequest, callback func(response *DescribeDataCheckTableDiffDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataCheckTableDiffDetailsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataCheckTableDiffDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataCheckTableDiffDetailsRequest is the request struct for api DescribeDataCheckTableDiffDetails
type DescribeDataCheckTableDiffDetailsRequest struct {
	*requests.RpcRequest
	JobStepId  string           `position:"Query" name:"JobStepId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	TbName     string           `position:"Query" name:"TbName"`
	DbName     string           `position:"Query" name:"DbName"`
}

// DescribeDataCheckTableDiffDetailsResponse is the response struct for api DescribeDataCheckTableDiffDetails
type DescribeDataCheckTableDiffDetailsResponse struct {
	*responses.BaseResponse
	RequestId      string            `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrCode        string            `json:"ErrCode" xml:"ErrCode"`
	Success        bool              `json:"Success" xml:"Success"`
	ErrMessage     string            `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage string            `json:"DynamicMessage" xml:"DynamicMessage"`
	TbName         string            `json:"TbName" xml:"TbName"`
	DbName         string            `json:"DbName" xml:"DbName"`
	DiffCount      int64             `json:"DiffCount" xml:"DiffCount"`
	InstanceId     string            `json:"InstanceId" xml:"InstanceId"`
	DiffDetails    []DiffDetailsItem `json:"DiffDetails" xml:"DiffDetails"`
}

// CreateDescribeDataCheckTableDiffDetailsRequest creates a request to invoke DescribeDataCheckTableDiffDetails API
func CreateDescribeDataCheckTableDiffDetailsRequest() (request *DescribeDataCheckTableDiffDetailsRequest) {
	request = &DescribeDataCheckTableDiffDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeDataCheckTableDiffDetails", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDataCheckTableDiffDetailsResponse creates a response to parse from DescribeDataCheckTableDiffDetails response
func CreateDescribeDataCheckTableDiffDetailsResponse() (response *DescribeDataCheckTableDiffDetailsResponse) {
	response = &DescribeDataCheckTableDiffDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
