package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDtsJobs invokes the dts.DescribeDtsJobs API synchronously
func (client *Client) DescribeDtsJobs(request *DescribeDtsJobsRequest) (response *DescribeDtsJobsResponse, err error) {
	response = CreateDescribeDtsJobsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDtsJobsWithChan invokes the dts.DescribeDtsJobs API asynchronously
func (client *Client) DescribeDtsJobsWithChan(request *DescribeDtsJobsRequest) (<-chan *DescribeDtsJobsResponse, <-chan error) {
	responseChan := make(chan *DescribeDtsJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDtsJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDtsJobsWithCallback invokes the dts.DescribeDtsJobs API asynchronously
func (client *Client) DescribeDtsJobsWithCallback(request *DescribeDtsJobsRequest, callback func(response *DescribeDtsJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDtsJobsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDtsJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDtsJobsRequest is the request struct for api DescribeDtsJobs
type DescribeDtsJobsRequest struct {
	*requests.RpcRequest
	OrderDirection     string           `position:"Query" name:"OrderDirection"`
	DedicatedClusterId string           `position:"Query" name:"DedicatedClusterId"`
	Type               string           `position:"Query" name:"Type"`
	PageNumber         requests.Integer `position:"Query" name:"PageNumber"`
	OrderColumn        string           `position:"Query" name:"OrderColumn"`
	ResourceGroupId    string           `position:"Query" name:"ResourceGroupId"`
	PageSize           requests.Integer `position:"Query" name:"PageSize"`
	DtsJobId           string           `position:"Query" name:"DtsJobId"`
	OriginType         string           `position:"Query" name:"OriginType"`
	GroupId            string           `position:"Query" name:"GroupId"`
	Params             string           `position:"Query" name:"Params"`
	OwnerId            string           `position:"Query" name:"OwnerId"`
	JobType            string           `position:"Query" name:"JobType"`
	Tags               string           `position:"Query" name:"Tags"`
	Region             string           `position:"Query" name:"Region"`
	DtsInstanceId      string           `position:"Query" name:"DtsInstanceId"`
	Status             string           `position:"Query" name:"Status"`
}

// DescribeDtsJobsResponse is the response struct for api DescribeDtsJobs
type DescribeDtsJobsResponse struct {
	*responses.BaseResponse
	HttpStatusCode   int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId        string         `json:"RequestId" xml:"RequestId"`
	ErrCode          string         `json:"ErrCode" xml:"ErrCode"`
	Success          bool           `json:"Success" xml:"Success"`
	PageRecordCount  int            `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount int            `json:"TotalRecordCount" xml:"TotalRecordCount"`
	ErrMessage       string         `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage   string         `json:"DynamicMessage" xml:"DynamicMessage"`
	PageNumber       int            `json:"PageNumber" xml:"PageNumber"`
	DynamicCode      string         `json:"DynamicCode" xml:"DynamicCode"`
	DtsJobList       []DtsJobStatus `json:"DtsJobList" xml:"DtsJobList"`
	EtlDemoList      []DtsJobStatus `json:"EtlDemoList" xml:"EtlDemoList"`
}

// CreateDescribeDtsJobsRequest creates a request to invoke DescribeDtsJobs API
func CreateDescribeDtsJobsRequest() (request *DescribeDtsJobsRequest) {
	request = &DescribeDtsJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeDtsJobs", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDtsJobsResponse creates a response to parse from DescribeDtsJobs response
func CreateDescribeDtsJobsResponse() (response *DescribeDtsJobsResponse) {
	response = &DescribeDtsJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
