package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMetricList invokes the dts.DescribeMetricList API synchronously
func (client *Client) DescribeMetricList(request *DescribeMetricListRequest) (response *DescribeMetricListResponse, err error) {
	response = CreateDescribeMetricListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMetricListWithChan invokes the dts.DescribeMetricList API asynchronously
func (client *Client) DescribeMetricListWithChan(request *DescribeMetricListRequest) (<-chan *DescribeMetricListResponse, <-chan error) {
	responseChan := make(chan *DescribeMetricListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMetricList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMetricListWithCallback invokes the dts.DescribeMetricList API asynchronously
func (client *Client) DescribeMetricListWithCallback(request *DescribeMetricListRequest, callback func(response *DescribeMetricListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMetricListResponse
		var err error
		defer close(result)
		response, err = client.DescribeMetricList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMetricListRequest is the request struct for api DescribeMetricList
type DescribeMetricListRequest struct {
	*requests.RpcRequest
	MetricType  string           `position:"Body" name:"MetricType"`
	ClientToken string           `position:"Body" name:"ClientToken"`
	StartTime   requests.Integer `position:"Body" name:"StartTime"`
	AccountId   string           `position:"Body" name:"AccountId"`
	Param       string           `position:"Body" name:"Param"`
	DtsJobId    string           `position:"Body" name:"DtsJobId"`
	MetricName  string           `position:"Body" name:"MetricName"`
	Period      requests.Integer `position:"Body" name:"Period"`
	EndTime     requests.Integer `position:"Body" name:"EndTime"`
	Env         string           `position:"Body" name:"Env"`
	OwnerID     string           `position:"Body" name:"OwnerID"`
}

// DescribeMetricListResponse is the response struct for api DescribeMetricList
type DescribeMetricListResponse struct {
	*responses.BaseResponse
	MetricType     string      `json:"MetricType" xml:"MetricType"`
	Param          string      `json:"Param" xml:"Param"`
	MetricName     string      `json:"MetricName" xml:"MetricName"`
	Period         int64       `json:"Period" xml:"Period"`
	Success        bool        `json:"Success" xml:"Success"`
	Code           string      `json:"Code" xml:"Code"`
	ErrCode        string      `json:"ErrCode" xml:"ErrCode"`
	ErrMessage     string      `json:"ErrMessage" xml:"ErrMessage"`
	DynamicMessage string      `json:"DynamicMessage" xml:"DynamicMessage"`
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	DataPoints     []DataPoint `json:"DataPoints" xml:"DataPoints"`
}

// CreateDescribeMetricListRequest creates a request to invoke DescribeMetricList API
func CreateDescribeMetricListRequest() (request *DescribeMetricListRequest) {
	request = &DescribeMetricListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeMetricList", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMetricListResponse creates a response to parse from DescribeMetricList response
func CreateDescribeMetricListResponse() (response *DescribeMetricListResponse) {
	response = &DescribeMetricListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
