package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDedicatedCluster invokes the dts.ModifyDedicatedCluster API synchronously
func (client *Client) ModifyDedicatedCluster(request *ModifyDedicatedClusterRequest) (response *ModifyDedicatedClusterResponse, err error) {
	response = CreateModifyDedicatedClusterResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDedicatedClusterWithChan invokes the dts.ModifyDedicatedCluster API asynchronously
func (client *Client) ModifyDedicatedClusterWithChan(request *ModifyDedicatedClusterRequest) (<-chan *ModifyDedicatedClusterResponse, <-chan error) {
	responseChan := make(chan *ModifyDedicatedClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDedicatedCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDedicatedClusterWithCallback invokes the dts.ModifyDedicatedCluster API asynchronously
func (client *Client) ModifyDedicatedClusterWithCallback(request *ModifyDedicatedClusterRequest, callback func(response *ModifyDedicatedClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDedicatedClusterResponse
		var err error
		defer close(result)
		response, err = client.ModifyDedicatedCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDedicatedClusterRequest is the request struct for api ModifyDedicatedCluster
type ModifyDedicatedClusterRequest struct {
	*requests.RpcRequest
	DedicatedClusterId   string           `position:"Query" name:"DedicatedClusterId"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
	DedicatedClusterName string           `position:"Query" name:"DedicatedClusterName"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	OversoldRatio        requests.Integer `position:"Query" name:"OversoldRatio"`
}

// ModifyDedicatedClusterResponse is the response struct for api ModifyDedicatedCluster
type ModifyDedicatedClusterResponse struct {
	*responses.BaseResponse
	HttpStatusCode     string `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	ErrCode            string `json:"ErrCode" xml:"ErrCode"`
	Success            string `json:"Success" xml:"Success"`
	ErrMessage         string `json:"ErrMessage" xml:"ErrMessage"`
	DedicatedClusterId string `json:"DedicatedClusterId" xml:"DedicatedClusterId"`
}

// CreateModifyDedicatedClusterRequest creates a request to invoke ModifyDedicatedCluster API
func CreateModifyDedicatedClusterRequest() (request *ModifyDedicatedClusterRequest) {
	request = &ModifyDedicatedClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "ModifyDedicatedCluster", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDedicatedClusterResponse creates a response to parse from ModifyDedicatedCluster response
func CreateModifyDedicatedClusterResponse() (response *ModifyDedicatedClusterResponse) {
	response = &ModifyDedicatedClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
