package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDtsJob invokes the dts.ModifyDtsJob API synchronously
func (client *Client) ModifyDtsJob(request *ModifyDtsJobRequest) (response *ModifyDtsJobResponse, err error) {
	response = CreateModifyDtsJobResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDtsJobWithChan invokes the dts.ModifyDtsJob API asynchronously
func (client *Client) ModifyDtsJobWithChan(request *ModifyDtsJobRequest) (<-chan *ModifyDtsJobResponse, <-chan error) {
	responseChan := make(chan *ModifyDtsJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDtsJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDtsJobWithCallback invokes the dts.ModifyDtsJob API asynchronously
func (client *Client) ModifyDtsJobWithCallback(request *ModifyDtsJobRequest, callback func(response *ModifyDtsJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDtsJobResponse
		var err error
		defer close(result)
		response, err = client.ModifyDtsJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDtsJobRequest is the request struct for api ModifyDtsJob
type ModifyDtsJobRequest struct {
	*requests.RpcRequest
	ClientToken                string `position:"Query" name:"ClientToken"`
	EtlOperatorColumnReference string `position:"Body" name:"EtlOperatorColumnReference"`
	DbList                     string `position:"Body" name:"DbList"`
	FileOssUrl                 string `position:"Query" name:"FileOssUrl"`
	OwnerId                    string `position:"Query" name:"OwnerId"`
	ModifyTypeEnum             string `position:"Body" name:"ModifyTypeEnum"`
	Reserved                   string `position:"Body" name:"Reserved"`
	FilterTableName            string `position:"Body" name:"FilterTableName"`
	DtsInstanceId              string `position:"Query" name:"DtsInstanceId"`
	SynchronizationDirection   string `position:"Query" name:"SynchronizationDirection"`
}

// ModifyDtsJobResponse is the response struct for api ModifyDtsJob
type ModifyDtsJobResponse struct {
	*responses.BaseResponse
	Status     string `json:"Status" xml:"Status"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DtsJobId   string `json:"DtsJobId" xml:"DtsJobId"`
	ErrCode    string `json:"ErrCode" xml:"ErrCode"`
	Success    bool   `json:"Success" xml:"Success"`
	ErrMessage bool   `json:"ErrMessage" xml:"ErrMessage"`
}

// CreateModifyDtsJobRequest creates a request to invoke ModifyDtsJob API
func CreateModifyDtsJobRequest() (request *ModifyDtsJobRequest) {
	request = &ModifyDtsJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "ModifyDtsJob", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDtsJobResponse creates a response to parse from ModifyDtsJob response
func CreateModifyDtsJobResponse() (response *ModifyDtsJobResponse) {
	response = &ModifyDtsJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
