package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ActivateOfficeSite invokes the ecd.ActivateOfficeSite API synchronously
func (client *Client) ActivateOfficeSite(request *ActivateOfficeSiteRequest) (response *ActivateOfficeSiteResponse, err error) {
	response = CreateActivateOfficeSiteResponse()
	err = client.DoAction(request, response)
	return
}

// ActivateOfficeSiteWithChan invokes the ecd.ActivateOfficeSite API asynchronously
func (client *Client) ActivateOfficeSiteWithChan(request *ActivateOfficeSiteRequest) (<-chan *ActivateOfficeSiteResponse, <-chan error) {
	responseChan := make(chan *ActivateOfficeSiteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ActivateOfficeSite(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ActivateOfficeSiteWithCallback invokes the ecd.ActivateOfficeSite API asynchronously
func (client *Client) ActivateOfficeSiteWithCallback(request *ActivateOfficeSiteRequest, callback func(response *ActivateOfficeSiteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ActivateOfficeSiteResponse
		var err error
		defer close(result)
		response, err = client.ActivateOfficeSite(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ActivateOfficeSiteRequest is the request struct for api ActivateOfficeSite
type ActivateOfficeSiteRequest struct {
	*requests.RpcRequest
	OfficeSiteId string `position:"Query" name:"OfficeSiteId"`
}

// ActivateOfficeSiteResponse is the response struct for api ActivateOfficeSite
type ActivateOfficeSiteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateActivateOfficeSiteRequest creates a request to invoke ActivateOfficeSite API
func CreateActivateOfficeSiteRequest() (request *ActivateOfficeSiteRequest) {
	request = &ActivateOfficeSiteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ActivateOfficeSite", "", "")
	request.Method = requests.POST
	return
}

// CreateActivateOfficeSiteResponse creates a response to parse from ActivateOfficeSite response
func CreateActivateOfficeSiteResponse() (response *ActivateOfficeSiteResponse) {
	response = &ActivateOfficeSiteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
