package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateADConnectorDirectory invokes the ecd.CreateADConnectorDirectory API synchronously
func (client *Client) CreateADConnectorDirectory(request *CreateADConnectorDirectoryRequest) (response *CreateADConnectorDirectoryResponse, err error) {
	response = CreateCreateADConnectorDirectoryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateADConnectorDirectoryWithChan invokes the ecd.CreateADConnectorDirectory API asynchronously
func (client *Client) CreateADConnectorDirectoryWithChan(request *CreateADConnectorDirectoryRequest) (<-chan *CreateADConnectorDirectoryResponse, <-chan error) {
	responseChan := make(chan *CreateADConnectorDirectoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateADConnectorDirectory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateADConnectorDirectoryWithCallback invokes the ecd.CreateADConnectorDirectory API asynchronously
func (client *Client) CreateADConnectorDirectoryWithCallback(request *CreateADConnectorDirectoryRequest, callback func(response *CreateADConnectorDirectoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateADConnectorDirectoryResponse
		var err error
		defer close(result)
		response, err = client.CreateADConnectorDirectory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateADConnectorDirectoryRequest is the request struct for api CreateADConnectorDirectory
type CreateADConnectorDirectoryRequest struct {
	*requests.RpcRequest
	SubDomainDnsAddress *[]string        `position:"Query" name:"SubDomainDnsAddress"  type:"Repeated"`
	SubDomainName       string           `position:"Query" name:"SubDomainName"`
	DomainPassword      string           `position:"Query" name:"DomainPassword"`
	EnableAdminAccess   requests.Boolean `position:"Query" name:"EnableAdminAccess"`
	DesktopAccessType   string           `position:"Query" name:"DesktopAccessType"`
	DomainName          string           `position:"Query" name:"DomainName"`
	Specification       requests.Integer `position:"Query" name:"Specification"`
	DirectoryName       string           `position:"Query" name:"DirectoryName"`
	VSwitchId           *[]string        `position:"Query" name:"VSwitchId"  type:"Repeated"`
	MfaEnabled          requests.Boolean `position:"Query" name:"MfaEnabled"`
	DomainUserName      string           `position:"Query" name:"DomainUserName"`
	DnsAddress          *[]string        `position:"Query" name:"DnsAddress"  type:"Repeated"`
}

// CreateADConnectorDirectoryResponse is the response struct for api CreateADConnectorDirectory
type CreateADConnectorDirectoryResponse struct {
	*responses.BaseResponse
	TrustPassword string        `json:"TrustPassword" xml:"TrustPassword"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	DirectoryId   string        `json:"DirectoryId" xml:"DirectoryId"`
	AdConnectors  []AdConnector `json:"AdConnectors" xml:"AdConnectors"`
}

// CreateCreateADConnectorDirectoryRequest creates a request to invoke CreateADConnectorDirectory API
func CreateCreateADConnectorDirectoryRequest() (request *CreateADConnectorDirectoryRequest) {
	request = &CreateADConnectorDirectoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "CreateADConnectorDirectory", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateADConnectorDirectoryResponse creates a response to parse from CreateADConnectorDirectory response
func CreateCreateADConnectorDirectoryResponse() (response *CreateADConnectorDirectoryResponse) {
	response = &CreateADConnectorDirectoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
