package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDesktops invokes the ecd.CreateDesktops API synchronously
func (client *Client) CreateDesktops(request *CreateDesktopsRequest) (response *CreateDesktopsResponse, err error) {
	response = CreateCreateDesktopsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDesktopsWithChan invokes the ecd.CreateDesktops API asynchronously
func (client *Client) CreateDesktopsWithChan(request *CreateDesktopsRequest) (<-chan *CreateDesktopsResponse, <-chan error) {
	responseChan := make(chan *CreateDesktopsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDesktops(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDesktopsWithCallback invokes the ecd.CreateDesktops API asynchronously
func (client *Client) CreateDesktopsWithCallback(request *CreateDesktopsRequest, callback func(response *CreateDesktopsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDesktopsResponse
		var err error
		defer close(result)
		response, err = client.CreateDesktops(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDesktopsRequest is the request struct for api CreateDesktops
type CreateDesktopsRequest struct {
	*requests.RpcRequest
	VolumeEncryptionKey     string               `position:"Query" name:"VolumeEncryptionKey"`
	OfficeSiteId            string               `position:"Query" name:"OfficeSiteId"`
	ImageId                 string               `position:"Query" name:"ImageId"`
	BundleId                string               `position:"Query" name:"BundleId"`
	UserAssignMode          string               `position:"Query" name:"UserAssignMode"`
	Hostname                string               `position:"Query" name:"Hostname"`
	DesktopNameSuffix       requests.Boolean     `position:"Query" name:"DesktopNameSuffix"`
	SystemDiskSize          string               `position:"Query" name:"SystemDiskSize"`
	DirectoryId             string               `position:"Query" name:"DirectoryId"`
	EndUserId               *[]string            `position:"Query" name:"EndUserId"  type:"Repeated"`
	Tag                     *[]CreateDesktopsTag `position:"Query" name:"Tag"  type:"Repeated"`
	VolumeEncryptionEnabled requests.Boolean     `position:"Query" name:"VolumeEncryptionEnabled"`
	DesktopName             string               `position:"Query" name:"DesktopName"`
	Amount                  requests.Integer     `position:"Query" name:"Amount"`
	Period                  requests.Integer     `position:"Query" name:"Period"`
	AutoPay                 requests.Boolean     `position:"Query" name:"AutoPay"`
	GroupId                 string               `position:"Query" name:"GroupId"`
	EcsInstanceType         string               `position:"Query" name:"EcsInstanceType"`
	PromotionId             string               `position:"Query" name:"PromotionId"`
	PeriodUnit              string               `position:"Query" name:"PeriodUnit"`
	AutoRenew               requests.Boolean     `position:"Query" name:"AutoRenew"`
	DataDiskSize            string               `position:"Query" name:"DataDiskSize"`
	VpcId                   string               `position:"Query" name:"VpcId"`
	ChargeType              string               `position:"Query" name:"ChargeType"`
	PolicyGroupId           string               `position:"Query" name:"PolicyGroupId"`
	UserName                string               `position:"Query" name:"UserName"`
}

// CreateDesktopsTag is a repeated param struct in CreateDesktopsRequest
type CreateDesktopsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateDesktopsResponse is the response struct for api CreateDesktops
type CreateDesktopsResponse struct {
	*responses.BaseResponse
	OrderId   string   `json:"OrderId" xml:"OrderId"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	DesktopId []string `json:"DesktopId" xml:"DesktopId"`
}

// CreateCreateDesktopsRequest creates a request to invoke CreateDesktops API
func CreateCreateDesktopsRequest() (request *CreateDesktopsRequest) {
	request = &CreateDesktopsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "CreateDesktops", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDesktopsResponse creates a response to parse from CreateDesktops response
func CreateCreateDesktopsResponse() (response *CreateDesktopsResponse) {
	response = &CreateDesktopsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
