package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFlowMetric invokes the ecd.DescribeFlowMetric API synchronously
func (client *Client) DescribeFlowMetric(request *DescribeFlowMetricRequest) (response *DescribeFlowMetricResponse, err error) {
	response = CreateDescribeFlowMetricResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFlowMetricWithChan invokes the ecd.DescribeFlowMetric API asynchronously
func (client *Client) DescribeFlowMetricWithChan(request *DescribeFlowMetricRequest) (<-chan *DescribeFlowMetricResponse, <-chan error) {
	responseChan := make(chan *DescribeFlowMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFlowMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFlowMetricWithCallback invokes the ecd.DescribeFlowMetric API asynchronously
func (client *Client) DescribeFlowMetricWithCallback(request *DescribeFlowMetricRequest, callback func(response *DescribeFlowMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFlowMetricResponse
		var err error
		defer close(result)
		response, err = client.DescribeFlowMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFlowMetricRequest is the request struct for api DescribeFlowMetric
type DescribeFlowMetricRequest struct {
	*requests.RpcRequest
	MetricType   string           `position:"Query" name:"MetricType"`
	Period       requests.Integer `position:"Query" name:"Period"`
	EndTime      string           `position:"Query" name:"EndTime"`
	StartTime    string           `position:"Query" name:"StartTime"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	InstanceType string           `position:"Query" name:"InstanceType"`
}

// DescribeFlowMetricResponse is the response struct for api DescribeFlowMetric
type DescribeFlowMetricResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeFlowMetricRequest creates a request to invoke DescribeFlowMetric API
func CreateDescribeFlowMetricRequest() (request *DescribeFlowMetricRequest) {
	request = &DescribeFlowMetricRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeFlowMetric", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeFlowMetricResponse creates a response to parse from DescribeFlowMetric response
func CreateDescribeFlowMetricResponse() (response *DescribeFlowMetricResponse) {
	response = &DescribeFlowMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
