package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVulOverview invokes the ecd.DescribeVulOverview API synchronously
func (client *Client) DescribeVulOverview(request *DescribeVulOverviewRequest) (response *DescribeVulOverviewResponse, err error) {
	response = CreateDescribeVulOverviewResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVulOverviewWithChan invokes the ecd.DescribeVulOverview API asynchronously
func (client *Client) DescribeVulOverviewWithChan(request *DescribeVulOverviewRequest) (<-chan *DescribeVulOverviewResponse, <-chan error) {
	responseChan := make(chan *DescribeVulOverviewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVulOverview(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVulOverviewWithCallback invokes the ecd.DescribeVulOverview API asynchronously
func (client *Client) DescribeVulOverviewWithCallback(request *DescribeVulOverviewRequest, callback func(response *DescribeVulOverviewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVulOverviewResponse
		var err error
		defer close(result)
		response, err = client.DescribeVulOverview(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVulOverviewRequest is the request struct for api DescribeVulOverview
type DescribeVulOverviewRequest struct {
	*requests.RpcRequest
}

// DescribeVulOverviewResponse is the response struct for api DescribeVulOverview
type DescribeVulOverviewResponse struct {
	*responses.BaseResponse
	NntfCount  int    `json:"NntfCount" xml:"NntfCount"`
	LaterCount int    `json:"LaterCount" xml:"LaterCount"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	AsapCount  int    `json:"AsapCount" xml:"AsapCount"`
}

// CreateDescribeVulOverviewRequest creates a request to invoke DescribeVulOverview API
func CreateDescribeVulOverviewRequest() (request *DescribeVulOverviewRequest) {
	request = &DescribeVulOverviewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeVulOverview", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVulOverviewResponse creates a response to parse from DescribeVulOverview response
func CreateDescribeVulOverviewResponse() (response *DescribeVulOverviewResponse) {
	response = &DescribeVulOverviewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
