package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDirectoryUsers invokes the ecd.ListDirectoryUsers API synchronously
func (client *Client) ListDirectoryUsers(request *ListDirectoryUsersRequest) (response *ListDirectoryUsersResponse, err error) {
	response = CreateListDirectoryUsersResponse()
	err = client.DoAction(request, response)
	return
}

// ListDirectoryUsersWithChan invokes the ecd.ListDirectoryUsers API asynchronously
func (client *Client) ListDirectoryUsersWithChan(request *ListDirectoryUsersRequest) (<-chan *ListDirectoryUsersResponse, <-chan error) {
	responseChan := make(chan *ListDirectoryUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDirectoryUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDirectoryUsersWithCallback invokes the ecd.ListDirectoryUsers API asynchronously
func (client *Client) ListDirectoryUsersWithCallback(request *ListDirectoryUsersRequest, callback func(response *ListDirectoryUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDirectoryUsersResponse
		var err error
		defer close(result)
		response, err = client.ListDirectoryUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDirectoryUsersRequest is the request struct for api ListDirectoryUsers
type ListDirectoryUsersRequest struct {
	*requests.RpcRequest
	OUPath      string           `position:"Query" name:"OUPath"`
	Filter      string           `position:"Query" name:"Filter"`
	NextToken   string           `position:"Query" name:"NextToken"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
	DirectoryId string           `position:"Query" name:"DirectoryId"`
}

// ListDirectoryUsersResponse is the response struct for api ListDirectoryUsers
type ListDirectoryUsersResponse struct {
	*responses.BaseResponse
	NextToken string `json:"NextToken" xml:"NextToken"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Users     []User `json:"Users" xml:"Users"`
}

// CreateListDirectoryUsersRequest creates a request to invoke ListDirectoryUsers API
func CreateListDirectoryUsersRequest() (request *ListDirectoryUsersRequest) {
	request = &ListDirectoryUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ListDirectoryUsers", "", "")
	request.Method = requests.POST
	return
}

// CreateListDirectoryUsersResponse creates a response to parse from ListDirectoryUsers response
func CreateListDirectoryUsersResponse() (response *ListDirectoryUsersResponse) {
	response = &ListDirectoryUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
