package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveUserFromDesktopGroup invokes the ecd.RemoveUserFromDesktopGroup API synchronously
func (client *Client) RemoveUserFromDesktopGroup(request *RemoveUserFromDesktopGroupRequest) (response *RemoveUserFromDesktopGroupResponse, err error) {
	response = CreateRemoveUserFromDesktopGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveUserFromDesktopGroupWithChan invokes the ecd.RemoveUserFromDesktopGroup API asynchronously
func (client *Client) RemoveUserFromDesktopGroupWithChan(request *RemoveUserFromDesktopGroupRequest) (<-chan *RemoveUserFromDesktopGroupResponse, <-chan error) {
	responseChan := make(chan *RemoveUserFromDesktopGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveUserFromDesktopGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveUserFromDesktopGroupWithCallback invokes the ecd.RemoveUserFromDesktopGroup API asynchronously
func (client *Client) RemoveUserFromDesktopGroupWithCallback(request *RemoveUserFromDesktopGroupRequest, callback func(response *RemoveUserFromDesktopGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveUserFromDesktopGroupResponse
		var err error
		defer close(result)
		response, err = client.RemoveUserFromDesktopGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveUserFromDesktopGroupRequest is the request struct for api RemoveUserFromDesktopGroup
type RemoveUserFromDesktopGroupRequest struct {
	*requests.RpcRequest
	EndUserIds      *[]string `position:"Query" name:"EndUserIds"  type:"Repeated"`
	DesktopGroupId  string    `position:"Query" name:"DesktopGroupId"`
	DesktopGroupIds *[]string `position:"Query" name:"DesktopGroupIds"  type:"Repeated"`
}

// RemoveUserFromDesktopGroupResponse is the response struct for api RemoveUserFromDesktopGroup
type RemoveUserFromDesktopGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveUserFromDesktopGroupRequest creates a request to invoke RemoveUserFromDesktopGroup API
func CreateRemoveUserFromDesktopGroupRequest() (request *RemoveUserFromDesktopGroupRequest) {
	request = &RemoveUserFromDesktopGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "RemoveUserFromDesktopGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveUserFromDesktopGroupResponse creates a response to parse from RemoveUserFromDesktopGroup response
func CreateRemoveUserFromDesktopGroupResponse() (response *RemoveUserFromDesktopGroupResponse) {
	response = &RemoveUserFromDesktopGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
