package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateActivation invokes the ecs.CreateActivation API synchronously
func (client *Client) CreateActivation(request *CreateActivationRequest) (response *CreateActivationResponse, err error) {
	response = CreateCreateActivationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateActivationWithChan invokes the ecs.CreateActivation API asynchronously
func (client *Client) CreateActivationWithChan(request *CreateActivationRequest) (<-chan *CreateActivationResponse, <-chan error) {
	responseChan := make(chan *CreateActivationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateActivation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateActivationWithCallback invokes the ecs.CreateActivation API asynchronously
func (client *Client) CreateActivationWithCallback(request *CreateActivationRequest, callback func(response *CreateActivationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateActivationResponse
		var err error
		defer close(result)
		response, err = client.CreateActivation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateActivationRequest is the request struct for api CreateActivation
type CreateActivationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer       `position:"Query" name:"ResourceOwnerId"`
	Description          string                 `position:"Query" name:"Description"`
	InstanceCount        requests.Integer       `position:"Query" name:"InstanceCount"`
	Tag                  *[]CreateActivationTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount string                 `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                 `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer       `position:"Query" name:"OwnerId"`
	InstanceName         string                 `position:"Query" name:"InstanceName"`
	TimeToLiveInHours    requests.Integer       `position:"Query" name:"TimeToLiveInHours"`
	IpAddressRange       string                 `position:"Query" name:"IpAddressRange"`
}

// CreateActivationTag is a repeated param struct in CreateActivationRequest
type CreateActivationTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateActivationResponse is the response struct for api CreateActivation
type CreateActivationResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ActivationCode string `json:"ActivationCode" xml:"ActivationCode"`
	ActivationId   string `json:"ActivationId" xml:"ActivationId"`
}

// CreateCreateActivationRequest creates a request to invoke CreateActivation API
func CreateCreateActivationRequest() (request *CreateActivationRequest) {
	request = &CreateActivationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "CreateActivation", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateActivationResponse creates a response to parse from CreateActivation response
func CreateCreateActivationResponse() (response *CreateActivationResponse) {
	response = &CreateActivationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
