package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteActivation invokes the ecs.DeleteActivation API synchronously
func (client *Client) DeleteActivation(request *DeleteActivationRequest) (response *DeleteActivationResponse, err error) {
	response = CreateDeleteActivationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteActivationWithChan invokes the ecs.DeleteActivation API asynchronously
func (client *Client) DeleteActivationWithChan(request *DeleteActivationRequest) (<-chan *DeleteActivationResponse, <-chan error) {
	responseChan := make(chan *DeleteActivationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteActivation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteActivationWithCallback invokes the ecs.DeleteActivation API asynchronously
func (client *Client) DeleteActivationWithCallback(request *DeleteActivationRequest, callback func(response *DeleteActivationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteActivationResponse
		var err error
		defer close(result)
		response, err = client.DeleteActivation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteActivationRequest is the request struct for api DeleteActivation
type DeleteActivationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ActivationId         string           `position:"Query" name:"ActivationId"`
}

// DeleteActivationResponse is the response struct for api DeleteActivation
type DeleteActivationResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Activation Activation `json:"Activation" xml:"Activation"`
}

// CreateDeleteActivationRequest creates a request to invoke DeleteActivation API
func CreateDeleteActivationRequest() (request *DeleteActivationRequest) {
	request = &DeleteActivationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DeleteActivation", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteActivationResponse creates a response to parse from DeleteActivation response
func CreateDeleteActivationResponse() (response *DeleteActivationResponse) {
	response = &DeleteActivationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
