package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConfigTemplates invokes the edas.ListConfigTemplates API synchronously
func (client *Client) ListConfigTemplates(request *ListConfigTemplatesRequest) (response *ListConfigTemplatesResponse, err error) {
	response = CreateListConfigTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListConfigTemplatesWithChan invokes the edas.ListConfigTemplates API asynchronously
func (client *Client) ListConfigTemplatesWithChan(request *ListConfigTemplatesRequest) (<-chan *ListConfigTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListConfigTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConfigTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConfigTemplatesWithCallback invokes the edas.ListConfigTemplates API asynchronously
func (client *Client) ListConfigTemplatesWithCallback(request *ListConfigTemplatesRequest, callback func(response *ListConfigTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConfigTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListConfigTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConfigTemplatesRequest is the request struct for api ListConfigTemplates
type ListConfigTemplatesRequest struct {
	*requests.RoaRequest
	PageSize    string `position:"Query" name:"PageSize"`
	Name        string `position:"Query" name:"Name"`
	CurrentPage string `position:"Query" name:"CurrentPage"`
	Id          string `position:"Query" name:"Id"`
}

// ListConfigTemplatesResponse is the response struct for api ListConfigTemplates
type ListConfigTemplatesResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Code      int                       `json:"Code" xml:"Code"`
	Message   string                    `json:"Message" xml:"Message"`
	Data      DataInListConfigTemplates `json:"Data" xml:"Data"`
}

// CreateListConfigTemplatesRequest creates a request to invoke ListConfigTemplates API
func CreateListConfigTemplatesRequest() (request *ListConfigTemplatesRequest) {
	request = &ListConfigTemplatesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListConfigTemplates", "/pop/v5/config_template", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListConfigTemplatesResponse creates a response to parse from ListConfigTemplates response
func CreateListConfigTemplatesResponse() (response *ListConfigTemplatesResponse) {
	response = &ListConfigTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
