package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartK8sAppPrecheck invokes the edas.StartK8sAppPrecheck API synchronously
func (client *Client) StartK8sAppPrecheck(request *StartK8sAppPrecheckRequest) (response *StartK8sAppPrecheckResponse, err error) {
	response = CreateStartK8sAppPrecheckResponse()
	err = client.DoAction(request, response)
	return
}

// StartK8sAppPrecheckWithChan invokes the edas.StartK8sAppPrecheck API asynchronously
func (client *Client) StartK8sAppPrecheckWithChan(request *StartK8sAppPrecheckRequest) (<-chan *StartK8sAppPrecheckResponse, <-chan error) {
	responseChan := make(chan *StartK8sAppPrecheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartK8sAppPrecheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartK8sAppPrecheckWithCallback invokes the edas.StartK8sAppPrecheck API asynchronously
func (client *Client) StartK8sAppPrecheckWithCallback(request *StartK8sAppPrecheckRequest, callback func(response *StartK8sAppPrecheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartK8sAppPrecheckResponse
		var err error
		defer close(result)
		response, err = client.StartK8sAppPrecheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartK8sAppPrecheckRequest is the request struct for api StartK8sAppPrecheck
type StartK8sAppPrecheckRequest struct {
	*requests.RoaRequest
	Replicas                 string `position:"Query" name:"Replicas"`
	RequestsEphemeralStorage string `position:"Query" name:"RequestsEphemeralStorage"`
	Envs                     string `position:"Query" name:"Envs"`
	Annotations              string `position:"Query" name:"Annotations"`
	ClusterId                string `position:"Query" name:"ClusterId"`
	RequestsMem              string `position:"Query" name:"RequestsMem"`
	LocalVolume              string `position:"Query" name:"LocalVolume"`
	EnvFroms                 string `position:"Query" name:"EnvFroms"`
	Labels                   string `position:"Query" name:"Labels"`
	LimitMem                 string `position:"Query" name:"LimitMem"`
	LimitEphemeralStorage    string `position:"Query" name:"LimitEphemeralStorage"`
	LimitmCpu                string `position:"Query" name:"LimitmCpu"`
	ConfigMountDescs         string `position:"Query" name:"ConfigMountDescs"`
	AppName                  string `position:"Query" name:"AppName"`
	PackageUrl               string `position:"Query" name:"PackageUrl"`
	AppId                    string `position:"Query" name:"AppId"`
	EmptyDirs                string `position:"Query" name:"EmptyDirs"`
	PvcMountDescs            string `position:"Query" name:"PvcMountDescs"`
	ImageUrl                 string `position:"Query" name:"ImageUrl"`
	Namespace                string `position:"Query" name:"Namespace"`
	RequestsmCpu             string `position:"Query" name:"RequestsmCpu"`
	JavaStartUpConfig        string `position:"Query" name:"JavaStartUpConfig"`
}

// StartK8sAppPrecheckResponse is the response struct for api StartK8sAppPrecheck
type StartK8sAppPrecheckResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateStartK8sAppPrecheckRequest creates a request to invoke StartK8sAppPrecheck API
func CreateStartK8sAppPrecheckRequest() (request *StartK8sAppPrecheckRequest) {
	request = &StartK8sAppPrecheckRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "StartK8sAppPrecheck", "/pop/v5/k8s/app_precheck", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartK8sAppPrecheckResponse creates a response to parse from StartK8sAppPrecheck response
func CreateStartK8sAppPrecheckResponse() (response *StartK8sAppPrecheckResponse) {
	response = &StartK8sAppPrecheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
