package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLocalImage invokes the ehpc.DeleteLocalImage API synchronously
func (client *Client) DeleteLocalImage(request *DeleteLocalImageRequest) (response *DeleteLocalImageResponse, err error) {
	response = CreateDeleteLocalImageResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLocalImageWithChan invokes the ehpc.DeleteLocalImage API asynchronously
func (client *Client) DeleteLocalImageWithChan(request *DeleteLocalImageRequest) (<-chan *DeleteLocalImageResponse, <-chan error) {
	responseChan := make(chan *DeleteLocalImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLocalImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLocalImageWithCallback invokes the ehpc.DeleteLocalImage API asynchronously
func (client *Client) DeleteLocalImageWithCallback(request *DeleteLocalImageRequest, callback func(response *DeleteLocalImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLocalImageResponse
		var err error
		defer close(result)
		response, err = client.DeleteLocalImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLocalImageRequest is the request struct for api DeleteLocalImage
type DeleteLocalImageRequest struct {
	*requests.RpcRequest
	ClusterId     string `position:"Query" name:"ClusterId"`
	ContainerType string `position:"Query" name:"ContainerType"`
	ImageName     string `position:"Query" name:"ImageName"`
}

// DeleteLocalImageResponse is the response struct for api DeleteLocalImage
type DeleteLocalImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLocalImageRequest creates a request to invoke DeleteLocalImage API
func CreateDeleteLocalImageRequest() (request *DeleteLocalImageRequest) {
	request = &DeleteLocalImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "DeleteLocalImage", "", "")
	request.Method = requests.GET
	return
}

// CreateDeleteLocalImageResponse creates a response to parse from DeleteLocalImage response
func CreateDeleteLocalImageResponse() (response *DeleteLocalImageResponse) {
	response = &DeleteLocalImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
