package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPostScripts invokes the ehpc.GetPostScripts API synchronously
func (client *Client) GetPostScripts(request *GetPostScriptsRequest) (response *GetPostScriptsResponse, err error) {
	response = CreateGetPostScriptsResponse()
	err = client.DoAction(request, response)
	return
}

// GetPostScriptsWithChan invokes the ehpc.GetPostScripts API asynchronously
func (client *Client) GetPostScriptsWithChan(request *GetPostScriptsRequest) (<-chan *GetPostScriptsResponse, <-chan error) {
	responseChan := make(chan *GetPostScriptsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPostScripts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPostScriptsWithCallback invokes the ehpc.GetPostScripts API asynchronously
func (client *Client) GetPostScriptsWithCallback(request *GetPostScriptsRequest, callback func(response *GetPostScriptsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPostScriptsResponse
		var err error
		defer close(result)
		response, err = client.GetPostScripts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPostScriptsRequest is the request struct for api GetPostScripts
type GetPostScriptsRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// GetPostScriptsResponse is the response struct for api GetPostScripts
type GetPostScriptsResponse struct {
	*responses.BaseResponse
	RequestId          string                   `json:"RequestId" xml:"RequestId"`
	PostInstallScripts []PostInstallScriptsItem `json:"PostInstallScripts" xml:"PostInstallScripts"`
}

// CreateGetPostScriptsRequest creates a request to invoke GetPostScripts API
func CreateGetPostScriptsRequest() (request *GetPostScriptsRequest) {
	request = &GetPostScriptsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "GetPostScripts", "", "")
	request.Method = requests.GET
	return
}

// CreateGetPostScriptsResponse creates a response to parse from GetPostScripts response
func CreateGetPostScriptsResponse() (response *GetPostScriptsResponse) {
	response = &GetPostScriptsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
