package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetPostScripts invokes the ehpc.SetPostScripts API synchronously
func (client *Client) SetPostScripts(request *SetPostScriptsRequest) (response *SetPostScriptsResponse, err error) {
	response = CreateSetPostScriptsResponse()
	err = client.DoAction(request, response)
	return
}

// SetPostScriptsWithChan invokes the ehpc.SetPostScripts API asynchronously
func (client *Client) SetPostScriptsWithChan(request *SetPostScriptsRequest) (<-chan *SetPostScriptsResponse, <-chan error) {
	responseChan := make(chan *SetPostScriptsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetPostScripts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetPostScriptsWithCallback invokes the ehpc.SetPostScripts API asynchronously
func (client *Client) SetPostScriptsWithCallback(request *SetPostScriptsRequest, callback func(response *SetPostScriptsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetPostScriptsResponse
		var err error
		defer close(result)
		response, err = client.SetPostScripts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetPostScriptsRequest is the request struct for api SetPostScripts
type SetPostScriptsRequest struct {
	*requests.RpcRequest
	PostInstallScripts *[]SetPostScriptsPostInstallScripts `position:"Query" name:"PostInstallScripts"  type:"Repeated"`
	ClusterId          string                              `position:"Query" name:"ClusterId"`
}

// SetPostScriptsPostInstallScripts is a repeated param struct in SetPostScriptsRequest
type SetPostScriptsPostInstallScripts struct {
	Args string `name:"Args"`
	Url  string `name:"Url"`
}

// SetPostScriptsResponse is the response struct for api SetPostScripts
type SetPostScriptsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetPostScriptsRequest creates a request to invoke SetPostScripts API
func CreateSetPostScriptsRequest() (request *SetPostScriptsRequest) {
	request = &SetPostScriptsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "SetPostScripts", "", "")
	request.Method = requests.GET
	return
}

// CreateSetPostScriptsResponse creates a response to parse from SetPostScripts response
func CreateSetPostScriptsResponse() (response *SetPostScriptsResponse) {
	response = &SetPostScriptsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
