package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEventStreaming invokes the eventbridge.CreateEventStreaming API synchronously
func (client *Client) CreateEventStreaming(request *CreateEventStreamingRequest) (response *CreateEventStreamingResponse, err error) {
	response = CreateCreateEventStreamingResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEventStreamingWithChan invokes the eventbridge.CreateEventStreaming API asynchronously
func (client *Client) CreateEventStreamingWithChan(request *CreateEventStreamingRequest) (<-chan *CreateEventStreamingResponse, <-chan error) {
	responseChan := make(chan *CreateEventStreamingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEventStreaming(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEventStreamingWithCallback invokes the eventbridge.CreateEventStreaming API asynchronously
func (client *Client) CreateEventStreamingWithCallback(request *CreateEventStreamingRequest, callback func(response *CreateEventStreamingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEventStreamingResponse
		var err error
		defer close(result)
		response, err = client.CreateEventStreaming(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEventStreamingRequest is the request struct for api CreateEventStreaming
type CreateEventStreamingRequest struct {
	*requests.RpcRequest
	Sink               CreateEventStreamingSink       `position:"Body" name:"Sink"  type:"Struct"`
	Description        string                         `position:"Body" name:"Description"`
	FilterPattern      string                         `position:"Body" name:"FilterPattern"`
	Source             CreateEventStreamingSource     `position:"Body" name:"Source"  type:"Struct"`
	RunOptions         CreateEventStreamingRunOptions `position:"Body" name:"RunOptions"  type:"Struct"`
	EventStreamingName string                         `position:"Body" name:"EventStreamingName"`
	Tag                string                         `position:"Body" name:"Tag"`
}

// CreateEventStreamingSink is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSink struct {
	SinkRabbitMQParameters CreateEventStreamingSinkSinkRabbitMQParameters `name:"SinkRabbitMQParameters" type:"Struct"`
	SinkMNSParameters      CreateEventStreamingSinkSinkMNSParameters      `name:"SinkMNSParameters" type:"Struct"`
	SinkDataHubParameters  CreateEventStreamingSinkSinkDataHubParameters  `name:"SinkDataHubParameters" type:"Struct"`
	SinkKafkaParameters    CreateEventStreamingSinkSinkKafkaParameters    `name:"SinkKafkaParameters" type:"Struct"`
	SinkFcParameters       CreateEventStreamingSinkSinkFcParameters       `name:"SinkFcParameters" type:"Struct"`
	SinkSLSParameters      CreateEventStreamingSinkSinkSLSParameters      `name:"SinkSLSParameters" type:"Struct"`
	SinkRocketMQParameters CreateEventStreamingSinkSinkRocketMQParameters `name:"SinkRocketMQParameters" type:"Struct"`
}

// CreateEventStreamingSource is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSource struct {
	SourceMQTTParameters     CreateEventStreamingSourceSourceMQTTParameters     `name:"SourceMQTTParameters" type:"Struct"`
	SourceRocketMQParameters CreateEventStreamingSourceSourceRocketMQParameters `name:"SourceRocketMQParameters" type:"Struct"`
	SourceSLSParameters      CreateEventStreamingSourceSourceSLSParameters      `name:"SourceSLSParameters" type:"Struct"`
	SourceDTSParameters      CreateEventStreamingSourceSourceDTSParameters      `name:"SourceDTSParameters" type:"Struct"`
	SourceKafkaParameters    CreateEventStreamingSourceSourceKafkaParameters    `name:"SourceKafkaParameters" type:"Struct"`
	SourceMNSParameters      CreateEventStreamingSourceSourceMNSParameters      `name:"SourceMNSParameters" type:"Struct"`
	SourceRabbitMQParameters CreateEventStreamingSourceSourceRabbitMQParameters `name:"SourceRabbitMQParameters" type:"Struct"`
}

// CreateEventStreamingRunOptions is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingRunOptions struct {
	BatchWindow     CreateEventStreamingRunOptionsBatchWindow     `name:"BatchWindow" type:"Struct"`
	RetryStrategy   CreateEventStreamingRunOptionsRetryStrategy   `name:"RetryStrategy" type:"Struct"`
	DeadLetterQueue CreateEventStreamingRunOptionsDeadLetterQueue `name:"DeadLetterQueue" type:"Struct"`
	MaximumTasks    string                                        `name:"MaximumTasks"`
	ErrorsTolerance string                                        `name:"ErrorsTolerance"`
}

// CreateEventStreamingSinkSinkRabbitMQParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRabbitMQParameters struct {
	RoutingKey      CreateEventStreamingSinkSinkRabbitMQParametersRoutingKey      `name:"RoutingKey" type:"Struct"`
	QueueName       CreateEventStreamingSinkSinkRabbitMQParametersQueueName       `name:"QueueName" type:"Struct"`
	VirtualHostName CreateEventStreamingSinkSinkRabbitMQParametersVirtualHostName `name:"VirtualHostName" type:"Struct"`
	InstanceId      CreateEventStreamingSinkSinkRabbitMQParametersInstanceId      `name:"InstanceId" type:"Struct"`
	TargetType      CreateEventStreamingSinkSinkRabbitMQParametersTargetType      `name:"TargetType" type:"Struct"`
	MessageId       CreateEventStreamingSinkSinkRabbitMQParametersMessageId       `name:"MessageId" type:"Struct"`
	Exchange        CreateEventStreamingSinkSinkRabbitMQParametersExchange        `name:"Exchange" type:"Struct"`
	Body            CreateEventStreamingSinkSinkRabbitMQParametersBody            `name:"Body" type:"Struct"`
	Properties      CreateEventStreamingSinkSinkRabbitMQParametersProperties      `name:"Properties" type:"Struct"`
}

// CreateEventStreamingSinkSinkMNSParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkMNSParameters struct {
	QueueName      CreateEventStreamingSinkSinkMNSParametersQueueName      `name:"QueueName" type:"Struct"`
	IsBase64Encode CreateEventStreamingSinkSinkMNSParametersIsBase64Encode `name:"IsBase64Encode" type:"Struct"`
	Body           CreateEventStreamingSinkSinkMNSParametersBody           `name:"Body" type:"Struct"`
}

// CreateEventStreamingSinkSinkDataHubParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkDataHubParameters struct {
	RoleName    CreateEventStreamingSinkSinkDataHubParametersRoleName    `name:"RoleName" type:"Struct"`
	Project     CreateEventStreamingSinkSinkDataHubParametersProject     `name:"Project" type:"Struct"`
	Topic       CreateEventStreamingSinkSinkDataHubParametersTopic       `name:"Topic" type:"Struct"`
	TopicType   CreateEventStreamingSinkSinkDataHubParametersTopicType   `name:"TopicType" type:"Struct"`
	Body        CreateEventStreamingSinkSinkDataHubParametersBody        `name:"Body" type:"Struct"`
	TopicSchema CreateEventStreamingSinkSinkDataHubParametersTopicSchema `name:"TopicSchema" type:"Struct"`
}

// CreateEventStreamingSinkSinkKafkaParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkKafkaParameters struct {
	InstanceId CreateEventStreamingSinkSinkKafkaParametersInstanceId `name:"InstanceId" type:"Struct"`
	Acks       CreateEventStreamingSinkSinkKafkaParametersAcks       `name:"Acks" type:"Struct"`
	Topic      CreateEventStreamingSinkSinkKafkaParametersTopic      `name:"Topic" type:"Struct"`
	SaslUser   CreateEventStreamingSinkSinkKafkaParametersSaslUser   `name:"SaslUser" type:"Struct"`
	Value      CreateEventStreamingSinkSinkKafkaParametersValue      `name:"Value" type:"Struct"`
	Key        CreateEventStreamingSinkSinkKafkaParametersKey        `name:"Key" type:"Struct"`
}

// CreateEventStreamingSinkSinkFcParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkFcParameters struct {
	InvocationType CreateEventStreamingSinkSinkFcParametersInvocationType `name:"InvocationType" type:"Struct"`
	FunctionName   CreateEventStreamingSinkSinkFcParametersFunctionName   `name:"FunctionName" type:"Struct"`
	Qualifier      CreateEventStreamingSinkSinkFcParametersQualifier      `name:"Qualifier" type:"Struct"`
	ServiceName    CreateEventStreamingSinkSinkFcParametersServiceName    `name:"ServiceName" type:"Struct"`
	Body           CreateEventStreamingSinkSinkFcParametersBody           `name:"Body" type:"Struct"`
}

// CreateEventStreamingSinkSinkSLSParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkSLSParameters struct {
	RoleName CreateEventStreamingSinkSinkSLSParametersRoleName `name:"RoleName" type:"Struct"`
	Project  CreateEventStreamingSinkSinkSLSParametersProject  `name:"Project" type:"Struct"`
	Topic    CreateEventStreamingSinkSinkSLSParametersTopic    `name:"Topic" type:"Struct"`
	Body     CreateEventStreamingSinkSinkSLSParametersBody     `name:"Body" type:"Struct"`
	LogStore CreateEventStreamingSinkSinkSLSParametersLogStore `name:"LogStore" type:"Struct"`
}

// CreateEventStreamingSinkSinkRocketMQParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParameters struct {
	Keys             CreateEventStreamingSinkSinkRocketMQParametersKeys             `name:"Keys" type:"Struct"`
	VSwitchIds       CreateEventStreamingSinkSinkRocketMQParametersVSwitchIds       `name:"VSwitchIds" type:"Struct"`
	SecurityGroupId  CreateEventStreamingSinkSinkRocketMQParametersSecurityGroupId  `name:"SecurityGroupId" type:"Struct"`
	InstanceUsername CreateEventStreamingSinkSinkRocketMQParametersInstanceUsername `name:"InstanceUsername" type:"Struct"`
	Body             CreateEventStreamingSinkSinkRocketMQParametersBody             `name:"Body" type:"Struct"`
	Tags             CreateEventStreamingSinkSinkRocketMQParametersTags             `name:"Tags" type:"Struct"`
	Network          CreateEventStreamingSinkSinkRocketMQParametersNetwork          `name:"Network" type:"Struct"`
	InstancePassword CreateEventStreamingSinkSinkRocketMQParametersInstancePassword `name:"InstancePassword" type:"Struct"`
	InstanceId       CreateEventStreamingSinkSinkRocketMQParametersInstanceId       `name:"InstanceId" type:"Struct"`
	InstanceEndpoint CreateEventStreamingSinkSinkRocketMQParametersInstanceEndpoint `name:"InstanceEndpoint" type:"Struct"`
	VpcId            CreateEventStreamingSinkSinkRocketMQParametersVpcId            `name:"VpcId" type:"Struct"`
	Topic            CreateEventStreamingSinkSinkRocketMQParametersTopic            `name:"Topic" type:"Struct"`
	InstanceType     CreateEventStreamingSinkSinkRocketMQParametersInstanceType     `name:"InstanceType" type:"Struct"`
	Properties       CreateEventStreamingSinkSinkRocketMQParametersProperties       `name:"Properties" type:"Struct"`
}

// CreateEventStreamingSourceSourceMQTTParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSourceSourceMQTTParameters struct {
	InstanceId string `name:"InstanceId"`
	RegionId   string `name:"RegionId"`
	Topic      string `name:"Topic"`
}

// CreateEventStreamingSourceSourceRocketMQParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSourceSourceRocketMQParameters struct {
	FilterSql               string `name:"FilterSql"`
	InstanceSecurityGroupId string `name:"InstanceSecurityGroupId"`
	Offset                  string `name:"Offset"`
	VSwitchIds              string `name:"VSwitchIds"`
	GroupID                 string `name:"GroupID"`
	SecurityGroupId         string `name:"SecurityGroupId"`
	InstanceUsername        string `name:"InstanceUsername"`
	FilterType              string `name:"FilterType"`
	Network                 string `name:"Network"`
	AuthType                string `name:"AuthType"`
	InstancePassword        string `name:"InstancePassword"`
	InstanceVSwitchIds      string `name:"InstanceVSwitchIds"`
	InstanceNetwork         string `name:"InstanceNetwork"`
	InstanceId              string `name:"InstanceId"`
	InstanceEndpoint        string `name:"InstanceEndpoint"`
	InstanceVpcId           string `name:"InstanceVpcId"`
	RegionId                string `name:"RegionId"`
	VpcId                   string `name:"VpcId"`
	Topic                   string `name:"Topic"`
	InstanceType            string `name:"InstanceType"`
	Tag                     string `name:"Tag"`
	Timestamp               string `name:"Timestamp"`
}

// CreateEventStreamingSourceSourceSLSParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSourceSourceSLSParameters struct {
	RoleName        string `name:"RoleName"`
	Project         string `name:"Project"`
	LogStore        string `name:"LogStore"`
	ConsumePosition string `name:"ConsumePosition"`
}

// CreateEventStreamingSourceSourceDTSParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSourceSourceDTSParameters struct {
	BrokerUrl      string `name:"BrokerUrl"`
	Password       string `name:"Password"`
	InitCheckPoint string `name:"InitCheckPoint"`
	Topic          string `name:"Topic"`
	TaskId         string `name:"TaskId"`
	Sid            string `name:"Sid"`
	Username       string `name:"Username"`
}

// CreateEventStreamingSourceSourceKafkaParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSourceSourceKafkaParameters struct {
	InstanceId      string `name:"InstanceId"`
	ConsumerGroup   string `name:"ConsumerGroup"`
	RegionId        string `name:"RegionId"`
	VSwitchIds      string `name:"VSwitchIds"`
	VpcId           string `name:"VpcId"`
	SecurityGroupId string `name:"SecurityGroupId"`
	Topic           string `name:"Topic"`
	OffsetReset     string `name:"OffsetReset"`
	Network         string `name:"Network"`
}

// CreateEventStreamingSourceSourceMNSParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSourceSourceMNSParameters struct {
	QueueName      string `name:"QueueName"`
	RegionId       string `name:"RegionId"`
	IsBase64Decode string `name:"IsBase64Decode"`
}

// CreateEventStreamingSourceSourceRabbitMQParameters is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSourceSourceRabbitMQParameters struct {
	QueueName       string `name:"QueueName"`
	VirtualHostName string `name:"VirtualHostName"`
	InstanceId      string `name:"InstanceId"`
	RegionId        string `name:"RegionId"`
}

// CreateEventStreamingRunOptionsBatchWindow is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingRunOptionsBatchWindow struct {
	CountBasedWindow string `name:"CountBasedWindow"`
	TimeBasedWindow  string `name:"TimeBasedWindow"`
}

// CreateEventStreamingRunOptionsRetryStrategy is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingRunOptionsRetryStrategy struct {
	PushRetryStrategy        string `name:"PushRetryStrategy"`
	MaximumRetryAttempts     string `name:"MaximumRetryAttempts"`
	MaximumEventAgeInSeconds string `name:"MaximumEventAgeInSeconds"`
}

// CreateEventStreamingRunOptionsDeadLetterQueue is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingRunOptionsDeadLetterQueue struct {
	Arn string `name:"Arn"`
}

// CreateEventStreamingSinkSinkRabbitMQParametersRoutingKey is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRabbitMQParametersRoutingKey struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRabbitMQParametersQueueName is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRabbitMQParametersQueueName struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRabbitMQParametersVirtualHostName is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRabbitMQParametersVirtualHostName struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRabbitMQParametersInstanceId is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRabbitMQParametersInstanceId struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRabbitMQParametersTargetType is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRabbitMQParametersTargetType struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRabbitMQParametersMessageId is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRabbitMQParametersMessageId struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRabbitMQParametersExchange is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRabbitMQParametersExchange struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRabbitMQParametersBody is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRabbitMQParametersBody struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRabbitMQParametersProperties is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRabbitMQParametersProperties struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkMNSParametersQueueName is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkMNSParametersQueueName struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkMNSParametersIsBase64Encode is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkMNSParametersIsBase64Encode struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkMNSParametersBody is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkMNSParametersBody struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkDataHubParametersRoleName is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkDataHubParametersRoleName struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkDataHubParametersProject is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkDataHubParametersProject struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkDataHubParametersTopic is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkDataHubParametersTopic struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkDataHubParametersTopicType is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkDataHubParametersTopicType struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkDataHubParametersBody is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkDataHubParametersBody struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkDataHubParametersTopicSchema is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkDataHubParametersTopicSchema struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkKafkaParametersInstanceId is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkKafkaParametersInstanceId struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkKafkaParametersAcks is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkKafkaParametersAcks struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkKafkaParametersTopic is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkKafkaParametersTopic struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkKafkaParametersSaslUser is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkKafkaParametersSaslUser struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkKafkaParametersValue is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkKafkaParametersValue struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkKafkaParametersKey is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkKafkaParametersKey struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkFcParametersInvocationType is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkFcParametersInvocationType struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkFcParametersFunctionName is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkFcParametersFunctionName struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkFcParametersQualifier is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkFcParametersQualifier struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkFcParametersServiceName is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkFcParametersServiceName struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkFcParametersBody is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkFcParametersBody struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkSLSParametersRoleName is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkSLSParametersRoleName struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkSLSParametersProject is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkSLSParametersProject struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkSLSParametersTopic is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkSLSParametersTopic struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkSLSParametersBody is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkSLSParametersBody struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkSLSParametersLogStore is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkSLSParametersLogStore struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersKeys is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersKeys struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersVSwitchIds is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersVSwitchIds struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersSecurityGroupId is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersSecurityGroupId struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersInstanceUsername is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersInstanceUsername struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersBody is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersBody struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersTags is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersTags struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersNetwork is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersNetwork struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersInstancePassword is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersInstancePassword struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersInstanceId is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersInstanceId struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersInstanceEndpoint is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersInstanceEndpoint struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersVpcId is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersVpcId struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersTopic is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersTopic struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersInstanceType is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersInstanceType struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingSinkSinkRocketMQParametersProperties is a repeated param struct in CreateEventStreamingRequest
type CreateEventStreamingSinkSinkRocketMQParametersProperties struct {
	Template string `name:"Template"`
	Form     string `name:"Form"`
	Value    string `name:"Value"`
}

// CreateEventStreamingResponse is the response struct for api CreateEventStreaming
type CreateEventStreamingResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateEventStreamingRequest creates a request to invoke CreateEventStreaming API
func CreateCreateEventStreamingRequest() (request *CreateEventStreamingRequest) {
	request = &CreateEventStreamingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "CreateEventStreaming", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateEventStreamingResponse creates a response to parse from CreateEventStreaming response
func CreateCreateEventStreamingResponse() (response *CreateEventStreamingResponse) {
	response = &CreateEventStreamingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
