package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConnection invokes the eventbridge.GetConnection API synchronously
func (client *Client) GetConnection(request *GetConnectionRequest) (response *GetConnectionResponse, err error) {
	response = CreateGetConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// GetConnectionWithChan invokes the eventbridge.GetConnection API asynchronously
func (client *Client) GetConnectionWithChan(request *GetConnectionRequest) (<-chan *GetConnectionResponse, <-chan error) {
	responseChan := make(chan *GetConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConnectionWithCallback invokes the eventbridge.GetConnection API asynchronously
func (client *Client) GetConnectionWithCallback(request *GetConnectionRequest, callback func(response *GetConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConnectionResponse
		var err error
		defer close(result)
		response, err = client.GetConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConnectionRequest is the request struct for api GetConnection
type GetConnectionRequest struct {
	*requests.RpcRequest
	ConnectionName string `position:"Query" name:"ConnectionName"`
}

// GetConnectionResponse is the response struct for api GetConnection
type GetConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetConnectionRequest creates a request to invoke GetConnection API
func CreateGetConnectionRequest() (request *GetConnectionRequest) {
	request = &GetConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "GetConnection", "", "")
	request.Method = requests.POST
	return
}

// CreateGetConnectionResponse creates a response to parse from GetConnection response
func CreateGetConnectionResponse() (response *GetConnectionResponse) {
	response = &GetConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
