package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartEventStreaming invokes the eventbridge.StartEventStreaming API synchronously
func (client *Client) StartEventStreaming(request *StartEventStreamingRequest) (response *StartEventStreamingResponse, err error) {
	response = CreateStartEventStreamingResponse()
	err = client.DoAction(request, response)
	return
}

// StartEventStreamingWithChan invokes the eventbridge.StartEventStreaming API asynchronously
func (client *Client) StartEventStreamingWithChan(request *StartEventStreamingRequest) (<-chan *StartEventStreamingResponse, <-chan error) {
	responseChan := make(chan *StartEventStreamingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartEventStreaming(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartEventStreamingWithCallback invokes the eventbridge.StartEventStreaming API asynchronously
func (client *Client) StartEventStreamingWithCallback(request *StartEventStreamingRequest, callback func(response *StartEventStreamingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartEventStreamingResponse
		var err error
		defer close(result)
		response, err = client.StartEventStreaming(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartEventStreamingRequest is the request struct for api StartEventStreaming
type StartEventStreamingRequest struct {
	*requests.RpcRequest
	EventStreamingName string `position:"Body" name:"EventStreamingName"`
}

// StartEventStreamingResponse is the response struct for api StartEventStreaming
type StartEventStreamingResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      bool   `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateStartEventStreamingRequest creates a request to invoke StartEventStreaming API
func CreateStartEventStreamingRequest() (request *StartEventStreamingRequest) {
	request = &StartEventStreamingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "StartEventStreaming", "", "")
	request.Method = requests.POST
	return
}

// CreateStartEventStreamingResponse creates a response to parse from StartEventStreaming response
func CreateStartEventStreamingResponse() (response *StartEventStreamingResponse) {
	response = &StartEventStreamingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
