package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectPedestrianIntrusion invokes the facebody.DetectPedestrianIntrusion API synchronously
func (client *Client) DetectPedestrianIntrusion(request *DetectPedestrianIntrusionRequest) (response *DetectPedestrianIntrusionResponse, err error) {
	response = CreateDetectPedestrianIntrusionResponse()
	err = client.DoAction(request, response)
	return
}

// DetectPedestrianIntrusionWithChan invokes the facebody.DetectPedestrianIntrusion API asynchronously
func (client *Client) DetectPedestrianIntrusionWithChan(request *DetectPedestrianIntrusionRequest) (<-chan *DetectPedestrianIntrusionResponse, <-chan error) {
	responseChan := make(chan *DetectPedestrianIntrusionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectPedestrianIntrusion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectPedestrianIntrusionWithCallback invokes the facebody.DetectPedestrianIntrusion API asynchronously
func (client *Client) DetectPedestrianIntrusionWithCallback(request *DetectPedestrianIntrusionRequest, callback func(response *DetectPedestrianIntrusionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectPedestrianIntrusionResponse
		var err error
		defer close(result)
		response, err = client.DetectPedestrianIntrusion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectPedestrianIntrusionRequest is the request struct for api DetectPedestrianIntrusion
type DetectPedestrianIntrusionRequest struct {
	*requests.RpcRequest
	DetectRegion       *[]DetectPedestrianIntrusionDetectRegion `position:"Body" name:"DetectRegion"  type:"Json"`
	RegionType         string                                   `position:"Body" name:"RegionType"`
	FormatResultToJson requests.Boolean                         `position:"Query" name:"FormatResultToJson"`
	OssFile            string                                   `position:"Query" name:"OssFile"`
	RequestProxyBy     string                                   `position:"Query" name:"RequestProxyBy"`
	ImageURL           string                                   `position:"Body" name:"ImageURL"`
}

// DetectPedestrianIntrusionDetectRegion is a repeated param struct in DetectPedestrianIntrusionRequest
type DetectPedestrianIntrusionDetectRegion struct {
	Rect DetectPedestrianIntrusionDetectRegionRect `name:"Rect" type:"Struct"`
	Line DetectPedestrianIntrusionDetectRegionLine `name:"Line" type:"Struct"`
}

// DetectPedestrianIntrusionDetectRegionRect is a repeated param struct in DetectPedestrianIntrusionRequest
type DetectPedestrianIntrusionDetectRegionRect struct {
	Top    string `name:"Top"`
	Left   string `name:"Left"`
	Bottom string `name:"Bottom"`
	Right  string `name:"Right"`
}

// DetectPedestrianIntrusionDetectRegionLine is a repeated param struct in DetectPedestrianIntrusionRequest
type DetectPedestrianIntrusionDetectRegionLine struct {
	Y1 string `name:"Y1"`
	X1 string `name:"X1"`
	Y2 string `name:"Y2"`
	X2 string `name:"X2"`
}

// DetectPedestrianIntrusionResponse is the response struct for api DetectPedestrianIntrusion
type DetectPedestrianIntrusionResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectPedestrianIntrusionRequest creates a request to invoke DetectPedestrianIntrusion API
func CreateDetectPedestrianIntrusionRequest() (request *DetectPedestrianIntrusionRequest) {
	request = &DetectPedestrianIntrusionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "DetectPedestrianIntrusion", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectPedestrianIntrusionResponse creates a response to parse from DetectPedestrianIntrusion response
func CreateDetectPedestrianIntrusionResponse() (response *DetectPedestrianIntrusionResponse) {
	response = &DetectPedestrianIntrusionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
