package imageseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentSkin invokes the imageseg.SegmentSkin API synchronously
func (client *Client) SegmentSkin(request *SegmentSkinRequest) (response *SegmentSkinResponse, err error) {
	response = CreateSegmentSkinResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentSkinWithChan invokes the imageseg.SegmentSkin API asynchronously
func (client *Client) SegmentSkinWithChan(request *SegmentSkinRequest) (<-chan *SegmentSkinResponse, <-chan error) {
	responseChan := make(chan *SegmentSkinResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentSkin(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentSkinWithCallback invokes the imageseg.SegmentSkin API asynchronously
func (client *Client) SegmentSkinWithCallback(request *SegmentSkinRequest, callback func(response *SegmentSkinResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentSkinResponse
		var err error
		defer close(result)
		response, err = client.SegmentSkin(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentSkinRequest is the request struct for api SegmentSkin
type SegmentSkinRequest struct {
	*requests.RpcRequest
	OssFile        string `position:"Query" name:"OssFile"`
	RequestProxyBy string `position:"Query" name:"RequestProxyBy"`
	URL            string `position:"Body" name:"URL"`
}

// SegmentSkinResponse is the response struct for api SegmentSkin
type SegmentSkinResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentSkinRequest creates a request to invoke SegmentSkin API
func CreateSegmentSkinRequest() (request *SegmentSkinRequest) {
	request = &SegmentSkinRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageseg", "2019-12-30", "SegmentSkin", "", "")
	request.Method = requests.POST
	return
}

// CreateSegmentSkinResponse creates a response to parse from SegmentSkin response
func CreateSegmentSkinResponse() (response *SegmentSkinResponse) {
	response = &SegmentSkinResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
