package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachDestination invokes the iot.AttachDestination API synchronously
func (client *Client) AttachDestination(request *AttachDestinationRequest) (response *AttachDestinationResponse, err error) {
	response = CreateAttachDestinationResponse()
	err = client.DoAction(request, response)
	return
}

// AttachDestinationWithChan invokes the iot.AttachDestination API asynchronously
func (client *Client) AttachDestinationWithChan(request *AttachDestinationRequest) (<-chan *AttachDestinationResponse, <-chan error) {
	responseChan := make(chan *AttachDestinationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachDestination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachDestinationWithCallback invokes the iot.AttachDestination API asynchronously
func (client *Client) AttachDestinationWithCallback(request *AttachDestinationRequest, callback func(response *AttachDestinationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachDestinationResponse
		var err error
		defer close(result)
		response, err = client.AttachDestination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachDestinationRequest is the request struct for api AttachDestination
type AttachDestinationRequest struct {
	*requests.RpcRequest
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	DestinationId requests.Integer `position:"Query" name:"DestinationId"`
	ParserId      requests.Integer `position:"Query" name:"ParserId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	IsFailover    requests.Boolean `position:"Query" name:"IsFailover"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// AttachDestinationResponse is the response struct for api AttachDestination
type AttachDestinationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateAttachDestinationRequest creates a request to invoke AttachDestination API
func CreateAttachDestinationRequest() (request *AttachDestinationRequest) {
	request = &AttachDestinationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "AttachDestination", "", "")
	request.Method = requests.POST
	return
}

// CreateAttachDestinationResponse creates a response to parse from AttachDestination response
func CreateAttachDestinationResponse() (response *AttachDestinationResponse) {
	response = &AttachDestinationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
