package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchImportDevice invokes the iot.BatchImportDevice API synchronously
func (client *Client) BatchImportDevice(request *BatchImportDeviceRequest) (response *BatchImportDeviceResponse, err error) {
	response = CreateBatchImportDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// BatchImportDeviceWithChan invokes the iot.BatchImportDevice API asynchronously
func (client *Client) BatchImportDeviceWithChan(request *BatchImportDeviceRequest) (<-chan *BatchImportDeviceResponse, <-chan error) {
	responseChan := make(chan *BatchImportDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchImportDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchImportDeviceWithCallback invokes the iot.BatchImportDevice API asynchronously
func (client *Client) BatchImportDeviceWithCallback(request *BatchImportDeviceRequest, callback func(response *BatchImportDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchImportDeviceResponse
		var err error
		defer close(result)
		response, err = client.BatchImportDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchImportDeviceRequest is the request struct for api BatchImportDevice
type BatchImportDeviceRequest struct {
	*requests.RpcRequest
	IotInstanceId string                         `position:"Query" name:"IotInstanceId"`
	ProductKey    string                         `position:"Query" name:"ProductKey"`
	DeviceList    *[]BatchImportDeviceDeviceList `position:"Query" name:"DeviceList"  type:"Repeated"`
	ApiProduct    string                         `position:"Body" name:"ApiProduct"`
	ApiRevision   string                         `position:"Body" name:"ApiRevision"`
}

// BatchImportDeviceDeviceList is a repeated param struct in BatchImportDeviceRequest
type BatchImportDeviceDeviceList struct {
	DeviceSecret string `name:"DeviceSecret"`
	DeviceName   string `name:"DeviceName"`
	Sn           string `name:"Sn"`
}

// BatchImportDeviceResponse is the response struct for api BatchImportDevice
type BatchImportDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateBatchImportDeviceRequest creates a request to invoke BatchImportDevice API
func CreateBatchImportDeviceRequest() (request *BatchImportDeviceRequest) {
	request = &BatchImportDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchImportDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchImportDeviceResponse creates a response to parse from BatchImportDevice response
func CreateBatchImportDeviceResponse() (response *BatchImportDeviceResponse) {
	response = &BatchImportDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
