package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDestination invokes the iot.DeleteDestination API synchronously
func (client *Client) DeleteDestination(request *DeleteDestinationRequest) (response *DeleteDestinationResponse, err error) {
	response = CreateDeleteDestinationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDestinationWithChan invokes the iot.DeleteDestination API asynchronously
func (client *Client) DeleteDestinationWithChan(request *DeleteDestinationRequest) (<-chan *DeleteDestinationResponse, <-chan error) {
	responseChan := make(chan *DeleteDestinationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDestination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDestinationWithCallback invokes the iot.DeleteDestination API asynchronously
func (client *Client) DeleteDestinationWithCallback(request *DeleteDestinationRequest, callback func(response *DeleteDestinationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDestinationResponse
		var err error
		defer close(result)
		response, err = client.DeleteDestination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDestinationRequest is the request struct for api DeleteDestination
type DeleteDestinationRequest struct {
	*requests.RpcRequest
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	DestinationId requests.Integer `position:"Query" name:"DestinationId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// DeleteDestinationResponse is the response struct for api DeleteDestination
type DeleteDestinationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteDestinationRequest creates a request to invoke DeleteDestination API
func CreateDeleteDestinationRequest() (request *DeleteDestinationRequest) {
	request = &DeleteDestinationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteDestination", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDestinationResponse creates a response to parse from DeleteDestination response
func CreateDeleteDestinationResponse() (response *DeleteDestinationResponse) {
	response = &DeleteDestinationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
