package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSoundCodeLabel invokes the iot.DeleteSoundCodeLabel API synchronously
func (client *Client) DeleteSoundCodeLabel(request *DeleteSoundCodeLabelRequest) (response *DeleteSoundCodeLabelResponse, err error) {
	response = CreateDeleteSoundCodeLabelResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSoundCodeLabelWithChan invokes the iot.DeleteSoundCodeLabel API asynchronously
func (client *Client) DeleteSoundCodeLabelWithChan(request *DeleteSoundCodeLabelRequest) (<-chan *DeleteSoundCodeLabelResponse, <-chan error) {
	responseChan := make(chan *DeleteSoundCodeLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSoundCodeLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSoundCodeLabelWithCallback invokes the iot.DeleteSoundCodeLabel API asynchronously
func (client *Client) DeleteSoundCodeLabelWithCallback(request *DeleteSoundCodeLabelRequest, callback func(response *DeleteSoundCodeLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSoundCodeLabelResponse
		var err error
		defer close(result)
		response, err = client.DeleteSoundCodeLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSoundCodeLabelRequest is the request struct for api DeleteSoundCodeLabel
type DeleteSoundCodeLabelRequest struct {
	*requests.RpcRequest
	SoundCode     string `position:"Body" name:"SoundCode"`
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// DeleteSoundCodeLabelResponse is the response struct for api DeleteSoundCodeLabel
type DeleteSoundCodeLabelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteSoundCodeLabelRequest creates a request to invoke DeleteSoundCodeLabel API
func CreateDeleteSoundCodeLabelRequest() (request *DeleteSoundCodeLabelRequest) {
	request = &DeleteSoundCodeLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteSoundCodeLabel", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteSoundCodeLabelResponse creates a response to parse from DeleteSoundCodeLabel response
func CreateDeleteSoundCodeLabelResponse() (response *DeleteSoundCodeLabelResponse) {
	response = &DeleteSoundCodeLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
