package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataSourceItem invokes the iot.ListDataSourceItem API synchronously
func (client *Client) ListDataSourceItem(request *ListDataSourceItemRequest) (response *ListDataSourceItemResponse, err error) {
	response = CreateListDataSourceItemResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataSourceItemWithChan invokes the iot.ListDataSourceItem API asynchronously
func (client *Client) ListDataSourceItemWithChan(request *ListDataSourceItemRequest) (<-chan *ListDataSourceItemResponse, <-chan error) {
	responseChan := make(chan *ListDataSourceItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataSourceItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataSourceItemWithCallback invokes the iot.ListDataSourceItem API asynchronously
func (client *Client) ListDataSourceItemWithCallback(request *ListDataSourceItemRequest, callback func(response *ListDataSourceItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataSourceItemResponse
		var err error
		defer close(result)
		response, err = client.ListDataSourceItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataSourceItemRequest is the request struct for api ListDataSourceItem
type ListDataSourceItemRequest struct {
	*requests.RpcRequest
	SearchName    string           `position:"Query" name:"SearchName"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	DataSourceId  requests.Integer `position:"Query" name:"DataSourceId"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	Page          requests.Integer `position:"Query" name:"Page"`
}

// ListDataSourceItemResponse is the response struct for api ListDataSourceItem
type ListDataSourceItemResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	Success         bool            `json:"Success" xml:"Success"`
	Code            string          `json:"Code" xml:"Code"`
	ErrorMessage    string          `json:"ErrorMessage" xml:"ErrorMessage"`
	Page            int             `json:"Page" xml:"Page"`
	PageSize        int             `json:"PageSize" xml:"PageSize"`
	Total           int             `json:"Total" xml:"Total"`
	DataSourceItems DataSourceItems `json:"DataSourceItems" xml:"DataSourceItems"`
}

// CreateListDataSourceItemRequest creates a request to invoke ListDataSourceItem API
func CreateListDataSourceItemRequest() (request *ListDataSourceItemRequest) {
	request = &ListDataSourceItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListDataSourceItem", "", "")
	request.Method = requests.POST
	return
}

// CreateListDataSourceItemResponse creates a response to parse from ListDataSourceItem response
func CreateListDataSourceItemResponse() (response *ListDataSourceItemResponse) {
	response = &ListDataSourceItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
