package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListParser invokes the iot.ListParser API synchronously
func (client *Client) ListParser(request *ListParserRequest) (response *ListParserResponse, err error) {
	response = CreateListParserResponse()
	err = client.DoAction(request, response)
	return
}

// ListParserWithChan invokes the iot.ListParser API asynchronously
func (client *Client) ListParserWithChan(request *ListParserRequest) (<-chan *ListParserResponse, <-chan error) {
	responseChan := make(chan *ListParserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListParser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListParserWithCallback invokes the iot.ListParser API asynchronously
func (client *Client) ListParserWithCallback(request *ListParserRequest, callback func(response *ListParserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListParserResponse
		var err error
		defer close(result)
		response, err = client.ListParser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListParserRequest is the request struct for api ListParser
type ListParserRequest struct {
	*requests.RpcRequest
	SearchName    string           `position:"Query" name:"SearchName"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// ListParserResponse is the response struct for api ListParser
type ListParserResponse struct {
	*responses.BaseResponse
	RequestId    string           `json:"RequestId" xml:"RequestId"`
	Success      bool             `json:"Success" xml:"Success"`
	Code         string           `json:"Code" xml:"Code"`
	ErrorMessage string           `json:"ErrorMessage" xml:"ErrorMessage"`
	Total        int              `json:"Total" xml:"Total"`
	Data         DataInListParser `json:"Data" xml:"Data"`
}

// CreateListParserRequest creates a request to invoke ListParser API
func CreateListParserRequest() (request *ListParserRequest) {
	request = &ListParserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListParser", "", "")
	request.Method = requests.POST
	return
}

// CreateListParserResponse creates a response to parse from ListParser response
func CreateListParserResponse() (response *ListParserResponse) {
	response = &ListParserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
