package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryProjectShareDeviceList invokes the iot.QueryProjectShareDeviceList API synchronously
func (client *Client) QueryProjectShareDeviceList(request *QueryProjectShareDeviceListRequest) (response *QueryProjectShareDeviceListResponse, err error) {
	response = CreateQueryProjectShareDeviceListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryProjectShareDeviceListWithChan invokes the iot.QueryProjectShareDeviceList API asynchronously
func (client *Client) QueryProjectShareDeviceListWithChan(request *QueryProjectShareDeviceListRequest) (<-chan *QueryProjectShareDeviceListResponse, <-chan error) {
	responseChan := make(chan *QueryProjectShareDeviceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryProjectShareDeviceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryProjectShareDeviceListWithCallback invokes the iot.QueryProjectShareDeviceList API asynchronously
func (client *Client) QueryProjectShareDeviceListWithCallback(request *QueryProjectShareDeviceListRequest, callback func(response *QueryProjectShareDeviceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryProjectShareDeviceListResponse
		var err error
		defer close(result)
		response, err = client.QueryProjectShareDeviceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryProjectShareDeviceListRequest is the request struct for api QueryProjectShareDeviceList
type QueryProjectShareDeviceListRequest struct {
	*requests.RpcRequest
	PageId        requests.Integer `position:"Body" name:"PageId"`
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	ProductKey    string           `position:"Body" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Body" name:"DeviceName"`
}

// QueryProjectShareDeviceListResponse is the response struct for api QueryProjectShareDeviceList
type QueryProjectShareDeviceListResponse struct {
	*responses.BaseResponse
	RequestId    string                            `json:"RequestId" xml:"RequestId"`
	Success      bool                              `json:"Success" xml:"Success"`
	Code         string                            `json:"Code" xml:"Code"`
	ErrorMessage string                            `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryProjectShareDeviceList `json:"Data" xml:"Data"`
}

// CreateQueryProjectShareDeviceListRequest creates a request to invoke QueryProjectShareDeviceList API
func CreateQueryProjectShareDeviceListRequest() (request *QueryProjectShareDeviceListRequest) {
	request = &QueryProjectShareDeviceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryProjectShareDeviceList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryProjectShareDeviceListResponse creates a response to parse from QueryProjectShareDeviceList response
func CreateQueryProjectShareDeviceListResponse() (response *QueryProjectShareDeviceListResponse) {
	response = &QueryProjectShareDeviceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
