package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySoundCodeLabelBatchList invokes the iot.QuerySoundCodeLabelBatchList API synchronously
func (client *Client) QuerySoundCodeLabelBatchList(request *QuerySoundCodeLabelBatchListRequest) (response *QuerySoundCodeLabelBatchListResponse, err error) {
	response = CreateQuerySoundCodeLabelBatchListResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySoundCodeLabelBatchListWithChan invokes the iot.QuerySoundCodeLabelBatchList API asynchronously
func (client *Client) QuerySoundCodeLabelBatchListWithChan(request *QuerySoundCodeLabelBatchListRequest) (<-chan *QuerySoundCodeLabelBatchListResponse, <-chan error) {
	responseChan := make(chan *QuerySoundCodeLabelBatchListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySoundCodeLabelBatchList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySoundCodeLabelBatchListWithCallback invokes the iot.QuerySoundCodeLabelBatchList API asynchronously
func (client *Client) QuerySoundCodeLabelBatchListWithCallback(request *QuerySoundCodeLabelBatchListRequest, callback func(response *QuerySoundCodeLabelBatchListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySoundCodeLabelBatchListResponse
		var err error
		defer close(result)
		response, err = client.QuerySoundCodeLabelBatchList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySoundCodeLabelBatchListRequest is the request struct for api QuerySoundCodeLabelBatchList
type QuerySoundCodeLabelBatchListRequest struct {
	*requests.RpcRequest
	ScheduleCode  string           `position:"Body" name:"ScheduleCode"`
	PageId        requests.Integer `position:"Body" name:"PageId"`
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QuerySoundCodeLabelBatchListResponse is the response struct for api QuerySoundCodeLabelBatchList
type QuerySoundCodeLabelBatchListResponse struct {
	*responses.BaseResponse
	RequestId    string                             `json:"RequestId" xml:"RequestId"`
	Success      bool                               `json:"Success" xml:"Success"`
	Code         string                             `json:"Code" xml:"Code"`
	ErrorMessage string                             `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQuerySoundCodeLabelBatchList `json:"Data" xml:"Data"`
}

// CreateQuerySoundCodeLabelBatchListRequest creates a request to invoke QuerySoundCodeLabelBatchList API
func CreateQuerySoundCodeLabelBatchListRequest() (request *QuerySoundCodeLabelBatchListRequest) {
	request = &QuerySoundCodeLabelBatchListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySoundCodeLabelBatchList", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySoundCodeLabelBatchListResponse creates a response to parse from QuerySoundCodeLabelBatchList response
func CreateQuerySoundCodeLabelBatchListResponse() (response *QuerySoundCodeLabelBatchListResponse) {
	response = &QuerySoundCodeLabelBatchListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
