package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryVehicleDevice invokes the iot.QueryVehicleDevice API synchronously
func (client *Client) QueryVehicleDevice(request *QueryVehicleDeviceRequest) (response *QueryVehicleDeviceResponse, err error) {
	response = CreateQueryVehicleDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// QueryVehicleDeviceWithChan invokes the iot.QueryVehicleDevice API asynchronously
func (client *Client) QueryVehicleDeviceWithChan(request *QueryVehicleDeviceRequest) (<-chan *QueryVehicleDeviceResponse, <-chan error) {
	responseChan := make(chan *QueryVehicleDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryVehicleDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryVehicleDeviceWithCallback invokes the iot.QueryVehicleDevice API asynchronously
func (client *Client) QueryVehicleDeviceWithCallback(request *QueryVehicleDeviceRequest, callback func(response *QueryVehicleDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryVehicleDeviceResponse
		var err error
		defer close(result)
		response, err = client.QueryVehicleDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryVehicleDeviceRequest is the request struct for api QueryVehicleDevice
type QueryVehicleDeviceRequest struct {
	*requests.RpcRequest
	RealTenantId      string `position:"Query" name:"RealTenantId"`
	RealTripartiteKey string `position:"Query" name:"RealTripartiteKey"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	ProductKey        string `position:"Query" name:"ProductKey"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
	DeviceName        string `position:"Query" name:"DeviceName"`
}

// QueryVehicleDeviceResponse is the response struct for api QueryVehicleDevice
type QueryVehicleDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string                   `json:"RequestId" xml:"RequestId"`
	Success      bool                     `json:"Success" xml:"Success"`
	Code         string                   `json:"Code" xml:"Code"`
	ErrorMessage string                   `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryVehicleDevice `json:"Data" xml:"Data"`
}

// CreateQueryVehicleDeviceRequest creates a request to invoke QueryVehicleDevice API
func CreateQueryVehicleDeviceRequest() (request *QueryVehicleDeviceRequest) {
	request = &QueryVehicleDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryVehicleDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryVehicleDeviceResponse creates a response to parse from QueryVehicleDevice response
func CreateQueryVehicleDeviceResponse() (response *QueryVehicleDeviceResponse) {
	response = &QueryVehicleDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
