package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMultiRateConfig invokes the live.DeleteMultiRateConfig API synchronously
func (client *Client) DeleteMultiRateConfig(request *DeleteMultiRateConfigRequest) (response *DeleteMultiRateConfigResponse, err error) {
	response = CreateDeleteMultiRateConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMultiRateConfigWithChan invokes the live.DeleteMultiRateConfig API asynchronously
func (client *Client) DeleteMultiRateConfigWithChan(request *DeleteMultiRateConfigRequest) (<-chan *DeleteMultiRateConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteMultiRateConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMultiRateConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMultiRateConfigWithCallback invokes the live.DeleteMultiRateConfig API asynchronously
func (client *Client) DeleteMultiRateConfigWithCallback(request *DeleteMultiRateConfigRequest, callback func(response *DeleteMultiRateConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMultiRateConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteMultiRateConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMultiRateConfigRequest is the request struct for api DeleteMultiRateConfig
type DeleteMultiRateConfigRequest struct {
	*requests.RpcRequest
	DeleteAll  string           `position:"Query" name:"DeleteAll"`
	App        string           `position:"Query" name:"App"`
	GroupId    string           `position:"Query" name:"GroupId"`
	Templates  string           `position:"Query" name:"Templates"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteMultiRateConfigResponse is the response struct for api DeleteMultiRateConfig
type DeleteMultiRateConfigResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteMultiRateConfigRequest creates a request to invoke DeleteMultiRateConfig API
func CreateDeleteMultiRateConfigRequest() (request *DeleteMultiRateConfigRequest) {
	request = &DeleteMultiRateConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteMultiRateConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteMultiRateConfigResponse creates a response to parse from DeleteMultiRateConfig response
func CreateDeleteMultiRateConfigResponse() (response *DeleteMultiRateConfigResponse) {
	response = &DeleteMultiRateConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
