package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainLog invokes the live.DescribeLiveDomainLog API synchronously
func (client *Client) DescribeLiveDomainLog(request *DescribeLiveDomainLogRequest) (response *DescribeLiveDomainLogResponse, err error) {
	response = CreateDescribeLiveDomainLogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainLogWithChan invokes the live.DescribeLiveDomainLog API asynchronously
func (client *Client) DescribeLiveDomainLogWithChan(request *DescribeLiveDomainLogRequest) (<-chan *DescribeLiveDomainLogResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainLogWithCallback invokes the live.DescribeLiveDomainLog API asynchronously
func (client *Client) DescribeLiveDomainLogWithCallback(request *DescribeLiveDomainLogRequest, callback func(response *DescribeLiveDomainLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainLogResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainLogRequest is the request struct for api DescribeLiveDomainLog
type DescribeLiveDomainLogRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveDomainLogResponse is the response struct for api DescribeLiveDomainLog
type DescribeLiveDomainLogResponse struct {
	*responses.BaseResponse
	DomainName       string           `json:"DomainName" xml:"DomainName"`
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	DomainLogDetails DomainLogDetails `json:"DomainLogDetails" xml:"DomainLogDetails"`
}

// CreateDescribeLiveDomainLogRequest creates a request to invoke DescribeLiveDomainLog API
func CreateDescribeLiveDomainLogRequest() (request *DescribeLiveDomainLogRequest) {
	request = &DescribeLiveDomainLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainLog", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainLogResponse creates a response to parse from DescribeLiveDomainLog response
func CreateDescribeLiveDomainLogResponse() (response *DescribeLiveDomainLogResponse) {
	response = &DescribeLiveDomainLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
