package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamMonitorList invokes the live.DescribeLiveStreamMonitorList API synchronously
func (client *Client) DescribeLiveStreamMonitorList(request *DescribeLiveStreamMonitorListRequest) (response *DescribeLiveStreamMonitorListResponse, err error) {
	response = CreateDescribeLiveStreamMonitorListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamMonitorListWithChan invokes the live.DescribeLiveStreamMonitorList API asynchronously
func (client *Client) DescribeLiveStreamMonitorListWithChan(request *DescribeLiveStreamMonitorListRequest) (<-chan *DescribeLiveStreamMonitorListResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamMonitorListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamMonitorList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamMonitorListWithCallback invokes the live.DescribeLiveStreamMonitorList API asynchronously
func (client *Client) DescribeLiveStreamMonitorListWithCallback(request *DescribeLiveStreamMonitorListRequest, callback func(response *DescribeLiveStreamMonitorListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamMonitorListResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamMonitorList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamMonitorListRequest is the request struct for api DescribeLiveStreamMonitorList
type DescribeLiveStreamMonitorListRequest struct {
	*requests.RpcRequest
	MonitorId string           `position:"Query" name:"MonitorId"`
	PageNum   requests.Integer `position:"Query" name:"PageNum"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	OrderRule requests.Integer `position:"Query" name:"OrderRule"`
	Status    requests.Integer `position:"Query" name:"Status"`
}

// DescribeLiveStreamMonitorListResponse is the response struct for api DescribeLiveStreamMonitorList
type DescribeLiveStreamMonitorListResponse struct {
	*responses.BaseResponse
	Total                 int                     `json:"Total" xml:"Total"`
	RequestId             string                  `json:"RequestId" xml:"RequestId"`
	LiveStreamMonitorList []LiveStreamMonitorInfo `json:"LiveStreamMonitorList" xml:"LiveStreamMonitorList"`
}

// CreateDescribeLiveStreamMonitorListRequest creates a request to invoke DescribeLiveStreamMonitorList API
func CreateDescribeLiveStreamMonitorListRequest() (request *DescribeLiveStreamMonitorListRequest) {
	request = &DescribeLiveStreamMonitorListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamMonitorList", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamMonitorListResponse creates a response to parse from DescribeLiveStreamMonitorList response
func CreateDescribeLiveStreamMonitorListResponse() (response *DescribeLiveStreamMonitorListResponse) {
	response = &DescribeLiveStreamMonitorListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
