package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRTSNativeSDKPlayFailStatus invokes the live.DescribeRTSNativeSDKPlayFailStatus API synchronously
func (client *Client) DescribeRTSNativeSDKPlayFailStatus(request *DescribeRTSNativeSDKPlayFailStatusRequest) (response *DescribeRTSNativeSDKPlayFailStatusResponse, err error) {
	response = CreateDescribeRTSNativeSDKPlayFailStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRTSNativeSDKPlayFailStatusWithChan invokes the live.DescribeRTSNativeSDKPlayFailStatus API asynchronously
func (client *Client) DescribeRTSNativeSDKPlayFailStatusWithChan(request *DescribeRTSNativeSDKPlayFailStatusRequest) (<-chan *DescribeRTSNativeSDKPlayFailStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeRTSNativeSDKPlayFailStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRTSNativeSDKPlayFailStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRTSNativeSDKPlayFailStatusWithCallback invokes the live.DescribeRTSNativeSDKPlayFailStatus API asynchronously
func (client *Client) DescribeRTSNativeSDKPlayFailStatusWithCallback(request *DescribeRTSNativeSDKPlayFailStatusRequest, callback func(response *DescribeRTSNativeSDKPlayFailStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRTSNativeSDKPlayFailStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeRTSNativeSDKPlayFailStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRTSNativeSDKPlayFailStatusRequest is the request struct for api DescribeRTSNativeSDKPlayFailStatus
type DescribeRTSNativeSDKPlayFailStatusRequest struct {
	*requests.RpcRequest
	EndTime        string    `position:"Query" name:"EndTime"`
	DomainNameList *[]string `position:"Query" name:"DomainNameList"  type:"Json"`
	StartTime      string    `position:"Query" name:"StartTime"`
	DataInterval   string    `position:"Query" name:"DataInterval"`
}

// DescribeRTSNativeSDKPlayFailStatusResponse is the response struct for api DescribeRTSNativeSDKPlayFailStatus
type DescribeRTSNativeSDKPlayFailStatusResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	DataInterval   string `json:"DataInterval" xml:"DataInterval"`
	StartTime      string `json:"StartTime" xml:"StartTime"`
	EndTime        string `json:"EndTime" xml:"EndTime"`
	PlayFailStatus []Data `json:"PlayFailStatus" xml:"PlayFailStatus"`
}

// CreateDescribeRTSNativeSDKPlayFailStatusRequest creates a request to invoke DescribeRTSNativeSDKPlayFailStatus API
func CreateDescribeRTSNativeSDKPlayFailStatusRequest() (request *DescribeRTSNativeSDKPlayFailStatusRequest) {
	request = &DescribeRTSNativeSDKPlayFailStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeRTSNativeSDKPlayFailStatus", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRTSNativeSDKPlayFailStatusResponse creates a response to parse from DescribeRTSNativeSDKPlayFailStatus response
func CreateDescribeRTSNativeSDKPlayFailStatusResponse() (response *DescribeRTSNativeSDKPlayFailStatusResponse) {
	response = &DescribeRTSNativeSDKPlayFailStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
